package login;

import cn.quantgroup.tech.brave.service.ITechHttpClient;
import cn.quantgroup.xyqb.Bootstrap;
import cn.quantgroup.xyqb.Constants;
import cn.quantgroup.xyqb.controller.internal.user.InnerController;
import cn.quantgroup.xyqb.controller.external.UserController;
import cn.quantgroup.xyqb.model.AuthBean;
import cn.quantgroup.xyqb.model.JsonResult;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import javax.annotation.Resource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by 11 on 2017/1/3.
 */
@Slf4j
@RunWith(SpringJUnit4ClassRunner.class)
@SpringBootTest(classes = Bootstrap.class )
public class UserLoginTest {

  private MockHttpServletRequest request = new MockHttpServletRequest();;

  @Resource
  private UserController userController;

  @Resource
  private InnerController innerController;
    //注入brave-spring-boot-starter提供的techHttpClient
    @Resource
    private ITechHttpClient techHttpClient;

  @Test
  public void testBull() {
    String contacts = null;
    boolean notBlank = StringUtils.isNotBlank(contacts);
    System.out.println("-----------------------------result:"+notBlank);

  }
  @Test
  public void testJson() {
    JsonResult addressByUserId = innerController.findAddressByUserId(22L);
  //  JsonResult userByUserId = innerController.findUserByPhoneNo("17811111122");
    System.out.println("-------------result:"+addressByUserId);

  }

    /**
     * 用户密码登陆接口
     */
  @Test
  public void testUserLogin() {
    Long code = 1L;
    String format = String.format(Constants.ZERO_FILL_TEMPLATE, code);
    System.out.println("-----------format:"+format);
    //访问xyqb-user拿到登录token
        Long channelId = 1L;
        String appChannel = "3";
        Long createFrom = 152L;
        //String userId = "8c02a7b8-815f-4ba0-b39c-a9e6e52904de";
        //测试userId为空的情况
        String userId = "";
        String ip = "172.16.0.1";
        request.addHeader("x-original-client-ip", ip);
        request.addHeader("authorization", "Basic MTg1MTMzNDE4MDg6MTIzNDU2");
        JsonResult jsonResult = userController.login(channelId, appChannel, createFrom, userId,"xyqb","xyqb", request);
        AuthBean authBean = (AuthBean) jsonResult.getData();
        String token = authBean.getToken();
        System.out.println("user token:" + token);
        //用获取到的token请求xyqb的receive_token
        CloseableHttpClient httpClient =  techHttpClient.createHttpClientBuilder().build();
      HttpPost post = new HttpPost("http://localhost:9004/ex/login/receive_token");

        List<NameValuePair> pairList = new ArrayList<>();
        pairList.add(new BasicNameValuePair("token", token));
        HttpEntity entity = null;
        try {
            entity = new UrlEncodedFormEntity(pairList, "UTF-8");
        }catch (Exception e){
            log.error("error", e);
        }
        post.setEntity(entity);
        try {
            CloseableHttpResponse response = httpClient.execute(post);
            EntityUtils.toString(response.getEntity());
        } catch (IOException e) {
            log.error("error", e);
        }
  }

}
