package cn.quantgroup.xyqb.validator;

import cn.quantgroup.xyqb.util.ValidationUtil;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

/**
 * 中文姓名验证器, <ChineseName,String> String 对应的是可以对哪些类型校验
 *
 * @author ag
 */
public class ChineseNameValidator implements ConstraintValidator<ChineseName, String> {
    /**
     * 这个方法在初始化的时候调用. 如果配置错了, 你可以抛一个异常. 启动就报错了
     *
     * @param constraint
     */
    @Override
    public void initialize(ChineseName constraint) {
    }

    /**
     * 这....true = 校验通过. false = 校验失败
     *
     * @param userName 就是那个String
     * @param context
     * @return
     */
    @Override
    public boolean isValid(String userName, ConstraintValidatorContext context) {
        return ValidationUtil.validateChinese(userName);
    }
}
