package cn.quantgroup.xyqb.filter;

import cn.quantgroup.xyqb.Constants;
import cn.quantgroup.xyqb.controller.IBaseController;
import cn.quantgroup.xyqb.model.AppSmsUserParam;
import cn.quantgroup.xyqb.service.security.impl.UserDetailsBySmsService;
import cn.quantgroup.xyqb.service.sms.ISmsService;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationProvider;
import org.springframework.stereotype.Component;

import javax.servlet.http.HttpServletRequest;
import java.util.Base64;

/**
 * @author xiaoguang.xu
 * @time 2016-03-08 18:24
 */
@Component
public class SmsLoginAuthenticatedFilter extends AbstractPreAuthenticatedProcessingFilter implements IBaseController {

    private static final Logger LOGGER = LoggerFactory.getLogger(SmsLoginAuthenticatedFilter.class);

    private static final int SMS_VERIFICATION_MAXLEN = 6;

    @Autowired
    private RedisTemplate<String, String> stringRedisTemplate;
    @Autowired
    private ISmsService smsService;

    @Autowired
    public SmsLoginAuthenticatedFilter(UserDetailsBySmsService userDetailsService) {
        PreAuthenticatedAuthenticationProvider authProvider = new PreAuthenticatedAuthenticationProvider();
        authProvider.setPreAuthenticatedUserDetailsService(userDetailsService);
        this.setAuthenticationManager(authProvider::authenticate);
    }

    @Override
    protected Object getPreAuthenticatedPrincipal(HttpServletRequest request) {
        String path = request.getRequestURI();
        if (!"/user/login/fast".equals(path)) {
            return null;
        }
        String authorization = request.getHeader("Authorization");
        if (authorization == null) {
            return AppSmsUserParam.builder().errorMsg("登陆失败").build();
        }
        String[] basicUserAndCode = authorization.split(" ");
        if (basicUserAndCode == null || basicUserAndCode.length != 2) {
            return AppSmsUserParam.builder().errorMsg("登陆失败").build();
        }
        if (!"Verification".equals(basicUserAndCode[0])) {
            return AppSmsUserParam.builder().errorMsg("登陆失败").build();
        }
        String userAndCodeStr = new String(Base64.getDecoder().decode(basicUserAndCode[1]));
        String[] userCodeArray = userAndCodeStr.split(":");
        String verificationCode = userCodeArray[1];
        String phoneNo = userCodeArray[0];
        LOGGER.info("用户快速登录,phoneNo:{} , verificationCode:{}", phoneNo, verificationCode);
        if (!validSmsVerificationCode(phoneNo, verificationCode)) {
            LOGGER.info("用户快速登录，验证码校验失败,phoneNo:{} , verificationCode:{}", phoneNo, verificationCode);
            return AppSmsUserParam.builder().phoneNo(phoneNo).errorMsg("验证码错误").build();
        }
        String createdFrom = request.getParameter("createdFrom");
        if (StringUtils.isEmpty(createdFrom)) {
            createdFrom = "1";
        }
        String channelId = request.getParameter("channelId");
        request.setAttribute("channelId", channelId);
        request.setAttribute("createdFrom", createdFrom);
        AppSmsUserParam param = AppSmsUserParam.builder()
                .phoneNo(phoneNo)
                .registerFrom(Long.valueOf(createdFrom))
                .ip(getIp())
                .appChannel(getAppChannel())
                .channelId(Long.parseLong(channelId))
                .build();
        return param;
    }


    /**
     * 检查验证码是否正确
     *
     * @param phoneNo
     * @param smsVerificationCode
     * @return
     */
    private boolean validSmsVerificationCode(String phoneNo, String smsVerificationCode) {
        if (StringUtils.isEmpty(smsVerificationCode) || smsVerificationCode.length() != SMS_VERIFICATION_MAXLEN) {
            return false;
        }
        String key = Constants.REDIS_PREFIX_VERIFICATION_CODE + phoneNo;
        String randomCode = stringRedisTemplate.opsForValue().get(key);
        if (StringUtils.isEmpty(randomCode)) {
            return false;
        }
        String[] arr = randomCode.split(":");
        String unqiueId = arr[0];
        String code = arr[1];
        if (StringUtils.equals(code, smsVerificationCode)) {
            try {
                smsService.getSmsSender().confirmSmsResult("1", unqiueId);
            } catch (Exception e) {
                LOGGER.info("短信验证像短信中心确认失效");
            }
            return true;
        }
        return false;
    }

    @Override
    protected Object getPreAuthenticatedCredentials(HttpServletRequest request) {
        return "dummy credentials";
    }
}
