package cn.quantgroup.xyqb.filter;

import cn.quantgroup.xyqb.model.AppUserParam;
import cn.quantgroup.xyqb.service.security.impl.UserDetailsByPhoneService;
import cn.quantgroup.xyqb.util.IPUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationProvider;
import org.springframework.stereotype.Component;

import javax.servlet.http.HttpServletRequest;

/**
 * @author mengfan.feng
 * @time 2015-10-26 15:58
 */
@Component
public class AppAuthenticatedFilter extends AbstractPreAuthenticatedProcessingFilter {

    private static final Logger LOGGER = LoggerFactory.getLogger(AppAuthenticatedFilter.class);


    @Autowired
    public AppAuthenticatedFilter(UserDetailsByPhoneService userDetailsService) {
        PreAuthenticatedAuthenticationProvider authProvider = new PreAuthenticatedAuthenticationProvider();
        authProvider.setPreAuthenticatedUserDetailsService(userDetailsService);
        this.setAuthenticationManager(authProvider::authenticate);
    }

        @Override
        protected Object getPreAuthenticatedPrincipal(HttpServletRequest request) {
            String path = request.getRequestURI();
            if (!"/app/login".equals(path)) {
                return null;
            }

            String requestIp = IPUtil.getRemoteIP(request);
            String loginFrom = request.getParameter("registerFrom");
        if(StringUtils.isBlank(loginFrom)){
            loginFrom = "0";
        }
        LOGGER.info("第三方用户登录, loginFrom:{}, requestIp:{}", loginFrom, requestIp);

//        if (!configurationService.validateIp(loginFrom, requestIp)) {
//            LOGGER.info("第三方用户登录，ip校验失败, loginFrom:{}, requestIp:{}", loginFrom, requestIp);
//            return null;
//        }

        request.setAttribute("channelId", "1");
        request.setAttribute("createdFrom", loginFrom + "");
        AppUserParam param = AppUserParam.builder()
                .phoneNo(request.getParameter("phoneNo"))
                .registerFrom(Long.valueOf(loginFrom))
                .idNo(request.getParameter("idNo"))
                .name(request.getParameter("name"))
                .build();

        return param;
    }

    @Override
    protected Object getPreAuthenticatedCredentials(HttpServletRequest request) {
        return "dummy credentials";
    }
}
