package cn.quantgroup.xyqb.model;

import cn.quantgroup.xyqb.entity.UserDisableRecord;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * 只是为了兼容时间格式化问题，后续用户中心升级后，该model不需要
 */
@Data
public class UserDisableRecordModel {
    private Long id;
    private Long userId;

    private short operation_type;

    private String reason;

    private String createdBy;

    private String updatedBy;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime createdAt;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime updatedAt;

    public static UserDisableRecordModel from(UserDisableRecord userDisableRecord) {
        UserDisableRecordModel userDisableRecordModel = new UserDisableRecordModel();
        userDisableRecordModel.setUserId(userDisableRecord.getUserId());
        userDisableRecordModel.setId(userDisableRecord.getId());
        userDisableRecordModel.setReason(userDisableRecord.getReason());
        userDisableRecordModel.setOperation_type(userDisableRecord.getOperation_type());
        userDisableRecordModel.setCreatedAt(userDisableRecord.getCreatedAt());
        userDisableRecordModel.setUpdatedAt(userDisableRecord.getUpdatedAt());
        userDisableRecordModel.setCreatedBy(userDisableRecord.getCreatedBy());
        userDisableRecordModel.setUpdatedBy(userDisableRecord.getUpdatedBy());
        return userDisableRecordModel;
    }

}
