package cn.quantgroup.xyqb.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @author mengfan.feng
 */
public class Utils {

  private static Pattern pattern = Pattern.compile("(?<!\\d)(?:(?:1[34578]\\d{9})|(?:861[34578]\\d{9}))(?!\\d)");

  public static String safeMap2Str(Map<String, String> info) {
    if (null == info) {
      return null;
    }
    StringBuilder builder = new StringBuilder();
    builder.append("{");
    info.forEach((key, value) -> {
      if ("password".equals(key)) {
        return;
      }
      builder.append(key);
      builder.append("=");
      builder.append(value);
      builder.append(",");
    });
    builder.append("}");
    return builder.toString();
  }

  public static String coverPhone(String str){
    if(str.length()<=0)
      return "";
    if(str.length()>1024)  //长度超过1024的字符串不走正则匹配过滤手机号
      return "";
    Matcher matcher = pattern.matcher(str);
    Map<String,String> replaceMap = new HashMap<>();
    while (matcher.find()) {
      String group = matcher.group();
      String replace = group.substring(0,3).concat("****").concat(group.substring(7)).concat(" [".concat(PasswordUtil.MD5(group)).concat("]"));
      replaceMap.put(group,replace);
    }
    Set<Map.Entry<String, String>> entries = replaceMap.entrySet();
    for (Map.Entry<String, String> entry :entries){
      str = str.replaceAll(entry.getKey(),entry.getValue());
    }
    return str;
  }
}
