package cn.quantgroup.xyqb.service.user;

import cn.quantgroup.xyqb.entity.CustomerInfoEntity;
import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.entity.UserDetail;
import cn.quantgroup.xyqb.model.UserBrief;

import java.util.List;

/**
 * Created by 11 on 2016/12/29.
 */
public interface ITenantService {

    User getTenantUser(User user, Integer tenantId);

    UserDetail getTenantUserDetail(UserDetail userDetail, Integer tenantId);

    UserBrief getTenantCustomerInfo(UserDetail userDetail, Integer tenantId);

    CustomerInfoEntity getTenantCustomerInfo(User user, Integer tenantId);


    /**
     * @author -REYLI
     * @createTime 2021-11-17
     * @description 根据条件获取租户下用户列表
     * @param users
     * @param tenantId
     * @return Arraylist
     */
    List<User> selectUsersByTenantId(List<User> users, Integer tenantId);

    Long getTenantCustomerInfoByOpenId(String openId, Integer tenantId);


    List<User> validationTentIdByTentId(List<User> users, Integer tenantId);

}
