package cn.quantgroup.xyqb;

import com.weibo.api.motan.common.MotanConstants;
import com.weibo.api.motan.util.MotanSwitcherUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.scheduling.annotation.EnableAsync;

@ComponentScan(basePackages = {"cn.quantgroup.xyqb", "cn.quantgroup.cloudconfig"})
@EnableAutoConfiguration
@SpringBootApplication
@PropertySource(value = {"classpath:application.properties", "classpath:xyqb.properties"}, ignoreResourceNotFound = true)
@EnableCaching
@Configuration
@EnableAspectJAutoProxy
@EnableAsync
@Slf4j
public class Bootstrap {

  public static void main(String[] args) {
    SpringApplication springApplication = new SpringApplication(Bootstrap.class);
    springApplication.addListeners(new ApplicationListener<ContextRefreshedEvent>() {
      @Override
      public void onApplicationEvent(ContextRefreshedEvent event) {
        MotanSwitcherUtil.setSwitcherValue(MotanConstants.REGISTRY_HEARTBEAT_SWITCHER, true);
        log.info("注册zookeeper成功");
      }
    });
    springApplication.setRegisterShutdownHook(true);
    springApplication.run(args);
    log.info("server start...");
  }
}
