package cn.quantgroup.xyqb.service.user;

import cn.quantgroup.user.enums.BizType;
import cn.quantgroup.user.enums.Relation;
import cn.quantgroup.xyqb.entity.Contact;
import org.springframework.data.jpa.repository.Query;

import java.util.List;

/**
 * Created by Miraculous on 2017/1/3.
 */
public interface IContactService {
    /**
     * @param userId - 用户主键
     * @param trim   - 是否清除非法错误记录，true-清除，false-不清除
     * @return
     */
//    List<Contact> findByUserId(Long userId, boolean trim);

    List<Contact> findByUserIdAndBizType(Long userId, BizType bizType, boolean trim);

    Contact findById(Long id);

    /**
     * 批量保存用户联系人
     * 如果已存在联系人，则覆盖更新
     *
     * @param userId   - 用户主键
     * @param contacts - 联系人列表
     * @return
     */
    @Deprecated //因不能明确表述更新还是新增。已废弃
    List<Contact> save(Long userId, List<Contact> contacts);

    @Deprecated //因不能明确表述更新还是新增。已废弃
    Contact save(Contact contact);

    @Deprecated //因不能明确表述更新还是新增。已废弃
    Contact saveContact(String name, String phoneNo, Relation relation, Contact contact);

    void update(String name, String phoneNo, Relation relation, Long id);

    void save(List<Contact> contactList);

    List<Contact> findContactForUserId(Long userId);
}
