package cn.quantgroup.xyqb.event;

import cn.quantgroup.xyqb.entity.UserDetail;
import cn.quantgroup.xyqb.entity.UserHashMapping;
import cn.quantgroup.xyqb.repository.IUserHashMappingRepository;
import cn.quantgroup.xyqb.util.encrypt.MD5Util;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

/**
 * userDetail 更新时, 保存 hashMapping 数据
 */
@Component
public class UserDetailHashEventListener implements ApplicationListener<UserDetailUpdateEvent> {

    @Autowired
    private IUserHashMappingRepository userHashMappingRepository;


    @Override
    public void onApplicationEvent(UserDetailUpdateEvent event) {
        UserDetail userDetail = event.getUserDetail();

        UserHashMapping userHashMapping = userHashMappingRepository.findByUserId(userDetail.getUserId());

        String idNoMd5 = userHashMapping.getIdNoMd5();

        String idNo = userDetail.getIdNo().toUpperCase();

        String idNoMd5New = MD5Util.build(idNo);

        //新旧相同, 直接跳过
        if (StringUtils.equals(idNoMd5, idNoMd5New)) {
            return;
        }

        userHashMapping.setIdNoMd5(idNoMd5New);

        userHashMappingRepository.save(userHashMapping);

    }
}
