package cn.quantgroup.xyqb.controller.external;

import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.entity.UserHashMapping;
import cn.quantgroup.xyqb.model.JsonResult;
import cn.quantgroup.xyqb.repository.IUserHashMappingRepository;
import cn.quantgroup.xyqb.repository.IUserRepository;
import cn.quantgroup.xyqb.util.encrypt.MD5Util;
import com.google.common.base.Stopwatch;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

@Slf4j
@RestController
@RequestMapping("/ex/sync_hash")
public class SyncHashController {


    private Boolean isContinue = false;
    @Autowired
    private IUserRepository userRepository;

    private ExecutorService executorService = Executors.newSingleThreadExecutor();

    @Autowired
    private IUserHashMappingRepository userHashMappingRepository;

    /**
     * 发起同步
     *
     * @param startUserId
     * @param step
     * @return
     */
    @GetMapping("/start")
    public JsonResult sync(final Long startUserId, final Long step) {
        isContinue = true;
        executorService
                .execute(() -> {
                    Long startPosition = startUserId;
                    while (isContinue) {
                        Stopwatch started = Stopwatch.createStarted();
                        Long endPosition = startPosition + step;
                        List<User> users = userRepository.findByIdBetween(startPosition, endPosition);
                        if (users.isEmpty()) {
                            log.info("没有数据了. 结束了");
                            return;
                        }
                        log.info("查询用户需要的时间 : {}ms", started.elapsed(TimeUnit.MILLISECONDS));
                        users.forEach(user -> {
                            UserHashMapping userHashMapping = userHashMappingRepository.findByUserId(user.getId());
                            if (userHashMapping != null) {
                                return;
                            }
                            userHashMapping = new UserHashMapping();
                            userHashMapping.setUserId(user.getId());
                            userHashMapping.setPhoneNoMd5(MD5Util.build(user.getPhoneNo()));
                            userHashMappingRepository.saveAndFlush(userHashMapping);
                        });

                        log.info("来一波,start:{},end:{}", startPosition, endPosition);
                        startPosition = users.get(users.size() - 1).getId() + 1;

                        try {
                            Thread.sleep(250);
                        } catch (InterruptedException e) {
                        }
                    }
                });

        return JsonResult.buildSuccessResult(null);
    }

    /**
     * 暂停同步
     */
    @GetMapping("/stop")
    public JsonResult stop() {
        isContinue = false;
        return JsonResult.buildSuccessResult(null);
    }
}
