package cn.quantgroup.xyqb.service.user.impl;

import cn.quantgroup.xyqb.entity.UserSpouse;
import cn.quantgroup.xyqb.repository.IUserSpouseRepository;
import cn.quantgroup.xyqb.service.user.IUserSpouseService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
public class UserSpouseServiceImpl implements IUserSpouseService {

    @Autowired
    private IUserSpouseRepository userSpouseRepository;

    @Override
    @Cacheable(value = "userSpouseCache", key = "'spouse' + #userId", unless = "#result == null", cacheManager = "cacheManager")
    public UserSpouse findByUserId(Long userId) {
        return userSpouseRepository.findByUserId(userId);
    }

    @Override
    @CacheEvict(value = "userSpouseCache", key = "'spouse' + #userSpouse.userId", cacheManager = "cacheManager")
    public UserSpouse save(UserSpouse userSpouse) {
        return userSpouseRepository.save(userSpouse);
    }


}
