package cn.quantgroup.xyqb.event;

import java.util.Objects;

import javax.annotation.Resource;

import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

import cn.quantgroup.acolyte.buddhistscriptures.ingester.UserIngest;

/**
 * 发送到Kafka - 综合统计中心 - 登录
 *
 * @author renwc
 * @date 2018-07-03
 */
@Component
public class KafkaUserEventListener implements ApplicationListener<StatisticsEvent> {
    @Resource
    private UserIngest userIngest;

    @Override
    public void onApplicationEvent(StatisticsEvent event) {
        if(Objects.nonNull(event.getRegister())){
            userIngest.sendRegisterInfo(event.getRegister());
        }
        if(Objects.nonNull(event.getLogin())){
            userIngest.sendLoginInfo(event.getLogin());
        }
        if(Objects.nonNull(event.getUserRealInfo())){
            userIngest.sendUserRealInfo(event.getUserRealInfo());
        }
    }
}
