package cn.quantgroup.xyqb.xxlJob;

import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.entity.UserTag;
import cn.quantgroup.xyqb.repository.IUserRepository;
import cn.quantgroup.xyqb.repository.IUserTagRepository;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.annotation.XxlJob;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.stream.Collectors;

/**
 * 第一次上线对历史数据清理程序
 */
@Component
public class UserTagCleanJobHandler {
    @Autowired
    private IUserRepository userRepository;

    @Autowired
    private IUserTagRepository userTagRepository;

    @XxlJob(value = "WechatFollowStatusJobHandler")
    public ReturnT<String> execute(String param) throws Exception {
        Pageable pageable = new PageRequest(0, 500);
        Page<User> userPage = userRepository.findAll(pageable);
        while (CollectionUtils.isNotEmpty(userPage.getContent())) {
            List<UserTag> userTagList = userPage.getContent().stream().map(user -> {
                UserTag userTag = UserTag.builder()
                        .userId(user.getId()).registeredFrom(user.getRegisteredFrom()).tenantId(user.getTenantId())
                        .build();
                userTag.setCreatedAt(user.getCreatedAt());
                userTag.setUpdatedAt(user.getUpdatedAt());
                return userTag;
            }).collect(Collectors.toList());

            userTagRepository.save(userTagList);

            pageable = new PageRequest(pageable.getPageNumber() + 1, pageable.getPageSize());
            userPage = userRepository.findAll(pageable);
        }

        return ReturnT.SUCCESS;
    }
}
