package cn.quantgroup.xyqb.repository;

import cn.quantgroup.xyqb.entity.UserAttached;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

/**
 * Created by 11 on 2017/3/22.
 */
public interface IUserAttachedRepository extends JpaRepository<UserAttached, Long> {
    UserAttached findByUserId(Long userId);

    List<UserAttached> findByUserIdIn(List<Long> userId);

    @Transactional
    void deleteByUserId(Long userId);

    @Query(value = "select * from user_attached where id>?1  limit 500" ,nativeQuery = true)
    List<UserAttached> findALlAttached(Long id);

}
