package cn.quantgroup.xyqb.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import lombok.Data;

/**
 * 用户综合信息数据模型
 *
 * @author renwc
 * @date 2018-01-04
 */
@Data
public class UserAssociationModel implements Serializable {
    private static final long serialVersionUID = -1L;
    private Long id;
    private String uuid;
    private String phoneNo;
    private String idNo;
    private String name;
    private String gender;
    private String qq;
    private String email;
    private Long registerFrom;
    private Long merchantId;
    // 婚姻状态
    private String marryStatus;
    // 受教育程度
    private String educationEnum;
    // 职业
    private String occupationEnum;
    // 收入水平范围
    private String incomeRangeEnum;
    // 收入方式
    private String incomeEnum;
    // 是否有车
    private Boolean hasCar;
    // 是否有社保
    private Boolean hasSocialSecurity;
    // 是否有房
    private Boolean hasHouse;
    // 是否有信用卡
    private Boolean hasCreditCard;
}
