package cn.quantgroup.xyqb.aspect.logcaller;

import cn.quantgroup.xyqb.util.ApplicationContextHolder;
import cn.quantgroup.xyqb.util.IPUtil;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;

/**
 * 调用者记录
 * Created by Administrator on 2017/5/15.
 */
@Aspect
@Component
@Order(value = Ordered.HIGHEST_PRECEDENCE)
public class LogCallHttpAspect {

    private static final Logger LOGGER = LoggerFactory.getLogger(LogCallHttpAspect.class);

    @Pointcut("@annotation(cn.quantgroup.xyqb.aspect.logcaller.LogHttpCaller)")
    private void logHttpCaller() {

    }


    @Around("logHttpCaller()")
    public Object record(ProceedingJoinPoint pjp) throws Throwable {
        Object result = pjp.proceed();
        // 异步记录调用日志
        try {
            ServletRequestAttributes attrs = (ServletRequestAttributes) RequestContextHolder
                    .getRequestAttributes();
            HttpServletRequest request = attrs.getRequest();
            String remoteIP = IPUtil.getRemoteIP(request);
            LogCallHttpAspect logCallHttpAspect = ApplicationContextHolder.getBean(LogCallHttpAspect.class);
            logCallHttpAspect.asyncRecordIt(pjp,result,remoteIP);
        }catch (Exception e){

        }
        return result;
    }

    //@Async
    public void asyncRecordIt(ProceedingJoinPoint pjp, Object result, String remoteIP){
        Object[] args = pjp.getArgs();
        String  methodName = pjp.getSignature().getName();
        String targetName = pjp.getTarget().getClass().getName();
        LOGGER.info("http api is called,from IP:[{}],method :[{}],args:[{}],response:[{}]",remoteIP,targetName.concat(".").concat(methodName),args,result);
    }

}
