package service;

import cn.quantgroup.xyqb.Bootstrap;
import cn.quantgroup.xyqb.entity.UserAuthorized;
import cn.quantgroup.xyqb.model.AuthPattern;
import cn.quantgroup.xyqb.model.UserAuthorizedParam;
import cn.quantgroup.xyqb.service.auth.IUserAuthorizedService;
import com.ctrip.framework.apollo.spring.config.ApolloPropertySourceInitializer;
import demo.BaseParametersTests;
import lombok.extern.slf4j.Slf4j;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.MethodSorters;
import org.junit.runners.Parameterized;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.annotation.Rollback;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;

/**
 * 业务层测试用例
 * @author renwc
 * @date 2018-01-05
 */
@Slf4j
@Rollback(true)
@Transactional
@FixMethodOrder(MethodSorters.NAME_ASCENDING)
@RunWith(value = Parameterized.class)
@SpringBootTest(classes = Bootstrap.class)
@ContextConfiguration(initializers = ApolloPropertySourceInitializer.class)
public class UserAuthorizedServiceTests extends BaseParametersTests {

    @Resource
    private IUserAuthorizedService userAuthorizedService;

    UserAuthorizedParam obj = new UserAuthorizedParam();
    public UserAuthorizedServiceTests(String userUuid, String idNo, String name, AuthPattern authPattern, Boolean available) {
        obj.setUserUuid(userUuid);
        obj.setIdNo(idNo);
        obj.setName(name);
        obj.setAuthPattern(Optional.ofNullable(authPattern).orElse(AuthPattern.ZMXY).name());
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{
                {"55544ae9-a1dd-458b-a7ac-2b4e64e59f99","350504198805144101","史书一", AuthPattern.ZMXY, true},
                {"2f7715f1-e59e-4169-8214-89aef11d2291","350504198805144102","史书二", AuthPattern.ZMXY, true},
                {"7addad2f-100b-49fa-ac44-bb729dfca06e","350504198805144103","史书三", AuthPattern.FOUR_ELEMENTS_OF_BANK_CARD, true},
                {"2dae9875-71ba-47bd-9332-0e4922f75f12", "IDNO-1", "王-1", AuthPattern.ZMXY, true}
        };
        return Arrays.asList(data);
    }

    @Test
    public void testExist() throws Exception {
        log.info("testExist: name:{}, idNo:{}, userId:{}, authPattern:{}", obj.getName(), obj.getIdNo(), obj.getUserUuid(), obj.getAuthPattern());
        Boolean exist = userAuthorizedService.hasUserAuthorized(this.obj.getIdNo());
        Assert.assertFalse(exist);
    }

    @Test
    public void testSave() throws Exception {
        log.info("testSave: name:{}, idNo:{}, userId:{}, authPattern:{}", obj.getName(), obj.getIdNo(), obj.getUserUuid(), obj.getAuthPattern());
        UserAuthorized o = userAuthorizedService.createUserAuthorized(this.obj);
        Assert.assertNotNull(o);
        Assert.assertEquals(obj.getIdNo(), o.getIdNo());
    }

    @Test
    public void testThenQuery(){
        log.info("testQuery: name:{}, idNo:{}, userId:{}, authPattern:{}", obj.getName(), obj.getIdNo(), obj.getUserUuid(), obj.getAuthPattern());
        Object o = userAuthorizedService.getUserAuthorizedId(this.obj.getUserUuid());
        Assert.assertNotNull(o);
    }

}
