package cn.quantgroup.xyqb.repository;


import cn.quantgroup.xyqb.entity.WechatUserInfo;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

import static org.springframework.transaction.annotation.Propagation.MANDATORY;

/**
 * Created by 11 on 2017/1/18.
 * modify by djh 20200527 http://confluence.quantgroup.cn/pages/viewpage.action?pageId=30657427
 */
public interface IWeChatUserRepository extends JpaRepository<WechatUserInfo, Long> {
    WechatUserInfo findByOpenIdAndAppNameAndAppIdAndTenantId(String openId, String appName, String appId, Integer tenantId);


    /**
     * 兼容历史逻辑，老的代码可能只通过appName进行支付宝、百度等登录
     * @param openId 用户的openId
     * @param appName 用户名
     * @param tenantId 租户id
     * @return
     */
    WechatUserInfo findByOpenIdAndAppNameAndTenantId(String openId, String appName, Integer tenantId);

    List<WechatUserInfo> findByOpenIdInAndAppIdAndTenantId(List<String> openId, String appId, Integer tenantId);

    List<WechatUserInfo> findByUnionIdInAndAppIdAndTenantId(List<String> unionIds, String appId, Integer tenantId);

    WechatUserInfo findByUnionIdAndAppIdAndTenantId(String openId, String appId, Integer tenantId);

    WechatUserInfo findByOpenIdAndAppIdAndTenantId(String openId, String appId, Integer tenantId);

    WechatUserInfo findByPhoneNoAndAppNameAndTenantId(String phoneNo, String appName, Integer tenantId);

    WechatUserInfo findByEncryptedPhoneNoAndAppNameAndTenantId(String phoneNo, String appName, Integer tenantId);

    WechatUserInfo findFirstByUserIdAndAppNameAndTenantIdOrderByCreatedAtDesc(Long userId, String appName, Integer tenantId);

    long countByOpenIdAndAppNameAndAppIdAndTenantId(String openId, String appName, String appId, Integer tenantId);

    /**
     * 解除关联关系 -- 当前用户的已关联微信
     * 注：应用服务的JDBC数据源连接，无delete权限
     *
     * @param userId
     * @return
     */
    @Transactional(rollbackFor = Exception.class)
    @Modifying
    @Query(value = "update wechat_userinfo set user_id=null,phone_no='*' where user_id=?1 and app_name=?2 and tenant_id=?3", nativeQuery = true)
    int dissociateByUserIdAndAppNameAndTenantId(Long userId, String appName, Integer tenantId);

    /**
     * 关联用户
     *
     * @param userId  - 用户标识
     * @param phoneNo
     * @param openId  - 微信标识
     * @return 记录更新行数
     */
    @Transactional(rollbackFor = Exception.class)
    @Modifying
    @Query(value = "update wechat_userinfo set user_id=?1,phone_no=?2 where open_id=?3 and user_id is null and app_name=?4 and app_id=?5 and tenant_id=?6", nativeQuery = true)
    int relateUser(Long userId, String phoneNo, String openId, String appName, String appId, Integer tenantId);

    /**
     * 解除关联关系 -- 包括：1、当前微信旧的关联用户；2、当前用户旧的关联微信
     * 强制事务
     *
     * @param openId - 微信标识
     * @param userId - 用户标识
     * @return 记录更新行数
     */
    @Transactional(propagation = MANDATORY, rollbackFor = Exception.class)
    @Modifying
    @Query(value = "update wechat_userinfo set user_id=null,phone_no='*' where (open_id=?1 or user_id=?2) and app_name=?3 and app_id=?4 and tenant_id=?5", nativeQuery = true)
    int dissociateUser(String openId, Long userId, String appName, String appId, Integer tenantId);


    /**
     * 更新unionId
     *
     * @param userId
     * @param appName
     * @param unionId
     * @return
     */
    @Transactional(rollbackFor = Exception.class)
    @Modifying
    @Query(value = "update wechat_userinfo set union_id=?3 where user_id=?1 and app_name=?2 and app_id=?4 and tenant_id=?5", nativeQuery = true)
    int updateUserUnionId(Long userId, String appName, String unionId, String appId, Integer tenantId);

    @Transactional
    void deleteByUserIdAndTenantId(Long userId, Integer tenantId);

    /**
     * 通过userId查询相关绑定微信记录
     */
    List<WechatUserInfo> findByUserIdAndTenantId(Long userId, Integer tenantId);
    List<WechatUserInfo> findByUserIdAndAppIdAndTenantId(Long userId, String appId,Integer tenantId);
    List<WechatUserInfo> findByUserIdInAndAppIdAndTenantId(List<Long> userIds,String appId, Integer tenantId);


    List<WechatUserInfo> findByPhoneNoAndTenantId(String phoneNo, Integer tenantId);

    /**
     * 通过unionId查询相关绑定微信记录
     */
    List<WechatUserInfo> findByUnionIdAndTenantId(String unionId, Integer tenantId);

    List<WechatUserInfo> findByUnionIdInAndTenantId(List<String> unionIds, Integer tenantId);

    List<WechatUserInfo> findByUserIdInAndAppNameAndTenantId(List<Long> userIds, String appName, Integer tenantId);
}
