package cn.quantgroup.xyqb.controller.tenant;

import cn.quantgroup.xyqb.entity.OauthClientDetailsEntity;
import cn.quantgroup.xyqb.entity.ProductLoginEntity;
import cn.quantgroup.xyqb.entity.UserDetail;
import cn.quantgroup.xyqb.model.JsonResult;
import cn.quantgroup.xyqb.service.user.IOauthClientDetailsService;
import cn.quantgroup.xyqb.service.user.IProductLoginService;
import cn.quantgroup.xyqb.service.user.IUserDetailService;
import cn.quantgroup.xyqb.service.user.IUserService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@Slf4j
@RestController
@RequestMapping("/tenant")
public class TenantController {

    @Autowired
    private IUserDetailService userDetailService;

    @Autowired
    private IProductLoginService productLoginService;

    @Autowired
    private IOauthClientDetailsService oauthClientDetailsService;

    /**
     * 根据用户ID查询租户列表
     * @param userId
     * @return
     */
    @PostMapping("/userIdTenantList")
    public JsonResult findTenantByUserId(Long userId) {
        // 通过userId获取租户机构和产品
        List<ProductLoginEntity> productLoginEntityList = productLoginService.findSlaveByUserId(userId);
        if (productLoginEntityList.isEmpty()) {
            return JsonResult.buildErrorStateResult("该用户不存在", null);
        }

        // 通过机构和产品Id 获取租户id
        List<Integer> tenantList = oauthClientDetailsService.findTenantList(productLoginEntityList);
        return JsonResult.buildSuccessResult("租户列表", tenantList);
    }


    @PostMapping("/queryUsersPage")
    public JsonResult queryUsersPage(Integer pageId, Integer pageSize) {

        Page<UserDetail> result = userDetailService.getUserDetailsPage(null, null, null, pageId, pageSize, "auto");

        return JsonResult.buildSuccessResult("查询成功", result);
    }

    @PostMapping("/queryOauthClientsPage")
    public JsonResult queryOauthClientsPage(Integer pageId, Integer pageSize) {

        Page<OauthClientDetailsEntity> result = oauthClientDetailsService.queryOauthClientsPage(pageId, pageSize);

        return JsonResult.buildSuccessResult("查询成功", result);
    }

}
