package cn.quantgroup.xyqb.service.register.impl;

import cn.quantgroup.xyqb.entity.Address;
import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.model.UserRegisterParam;
import cn.quantgroup.xyqb.service.register.AbstractUserRegisterService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

/**
 * Created by liqing on 2017/12/4 0004.
 */
@Service("userRegisterService")
@Slf4j
public class UserRegisterServiceImpl extends AbstractUserRegisterService {

    @Override
    public User registerDefault(UserRegisterParam userRegisterParam) {
        return getDefaultUserRegisterHandler().handleRegister(userRegisterParam);
    }

    @Override
    public User registerExt(UserRegisterParam userRegisterParam) {
        return getExtUserRegisterHandler().handleRegister(userRegisterParam);
    }

    @Override
    public User register(Long registerFrom, String phoneNo, String idNo, String name, Long channelId, Long btRegisterChannelId) {
        // 1、生成6位随机密码
        // 2、同步lkb
        // 3、保存user
        // 4、发送短信
        // 5、保存userDetail
        // 6、发送mq
        // 7、保存bt
        UserRegisterParam userRegisterParam = UserRegisterParam.builder()
                .registerFrom(registerFrom).phoneNo(phoneNo).idNo(idNo).name(name)
                .channelId(channelId).btRegisterChannelId(btRegisterChannelId)
                .generateRandomPwd(true).sendSuccessSms(true).sendAppSms(true)
                .sendSuccessMq(true)
                .build();
        return registerDefault(userRegisterParam);
    }

    @Override
    public User register(String phoneNo, String password, Long registerFrom) {
        // 1、同步lkb
        // 2、保存user
        UserRegisterParam userRegisterParam = UserRegisterParam.builder()
                .registerFrom(registerFrom).phoneNo(phoneNo).password(password)
                .generateRandomPwd(false).sendSuccessSms(true).sendAppSms(true)
                .sendSuccessMq(false)
                .build();
        return registerDefault(userRegisterParam);
    }

    @Override
    public boolean register(String phoneNo, String password, Long registerFrom, String ip, Long channelId, Long btRegisterChannelId, String dimension) {
        // 1、同步lkb
        // 2、保存user
        // 3、保存bt
        // 4、发送短信
        // 5、发送mq
        UserRegisterParam userRegisterParam = UserRegisterParam.builder()
                .registerFrom(registerFrom).phoneNo(phoneNo).password(password)
                .channelId(channelId).btRegisterChannelId(btRegisterChannelId)
                .dimension(dimension)
                .generateRandomPwd(false).sendSuccessSms(true).sendAppSms(true)
                .sendSuccessMq(true)
                .build();
        User user = registerDefault(userRegisterParam);
        return user != null;
    }

    @Override
    public User register(String phoneNo, Long channelId, Long registerFrom, String appChannel, Long btRegisterChannelId, String dimension) {
        // 1、生成15位随机密码
        // 2、同步lkb
        // 3、保存user
        // 4、保存bt
        // 5、发送mq
        UserRegisterParam userRegisterParam = UserRegisterParam.builder()
                .registerFrom(registerFrom).phoneNo(phoneNo)
                .channelId(channelId).btRegisterChannelId(btRegisterChannelId)
                .dimension(dimension)
                .generateRandomPwd(true).sendSuccessSms(false).sendAppSms(true)
                .sendSuccessMq(true)
                .build();
        return registerDefault(userRegisterParam);
    }

    @Override
    public User register(Long registeredFrom, Long channelId, String phoneNo, String name, String idNo, String provinceCode, String province, String cityCode, String city, String districtCode, String district, String address, String contacts) {
        // 1、生成6位随机密码
        // 2、同步lkb
        // 3、保存user
        // 4、保存bt：btRegisterChannelId = registeredFrom
        // 5、保存address
        // 6、保存userDetail
        // 7、保存联系人
        Address addressObj = new Address();
        addressObj.setProvinceCode(Long.valueOf(provinceCode));
        addressObj.setProvince(province);
        addressObj.setCityCode(Long.valueOf(cityCode));
        addressObj.setCity(city);
        addressObj.setDistrictCode(Long.valueOf(districtCode));
        addressObj.setDistrict(district);
        addressObj.setAddress(address);
        UserRegisterParam userRegisterParam = UserRegisterParam.builder()
                .registerFrom(registeredFrom).phoneNo(phoneNo).idNo(idNo).name(name)
                .channelId(channelId).btRegisterChannelId(registeredFrom)
                .address(addressObj).contacts(contacts)
                .generateRandomPwd(true).sendSuccessSms(false).sendAppSms(true)
                .sendSuccessMq(false)
                .build();
        return registerExt(userRegisterParam);
    }

    @Override
    public User register(Long registerFrom, String phoneNo, String idNo, String name, Long channelId) {
        // 1、生成6位随机密码
        // 2、同步lkb
        // 3、保存user
        // 4、发送短信
        // 5、保存userDetail
        UserRegisterParam userRegisterParam = UserRegisterParam.builder()
                .registerFrom(registerFrom).phoneNo(phoneNo).idNo(idNo).name(name)
                .channelId(channelId)
                .generateRandomPwd(true).sendSuccessSms(true).sendAppSms(true)
                .sendSuccessMq(false)
                .build();
        return registerDefault(userRegisterParam);
    }
}
