package cn.quantgroup.xyqb.repository;

import cn.quantgroup.xyqb.entity.User;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;


/**
 * Created by Miraculous on 15/7/4.
 */
public interface IUserRepository extends JpaRepository<User, Long>, JpaSpecificationExecutor<User> {

    User findByPhoneNoAndTenantId(String phoneNo,Integer tenantId);
    List<User> findByPhoneNoInAndTenantId(List<String> phoneNo,Integer tenantId);

    User findByEncryptedPhoneNoAndTenantId(String phoneNo,Integer tenantId);

    User findByUuidAndTenantId(String uuid,Integer tenantId);

    /**
     * 根据手机号查询用户UUID
     *
     * @param phoneNo - 手机号
     * @return user表的uuid
     */
    @Query(value = "select uuid from user where phone_no=?1 and tenant_id=?2", nativeQuery = true)
    String findUuidByPhoneNoAndTenantId(String phoneNo,Integer tenantId);


    List<User> findByIdInAndTenantId(List<Long> ids,Integer tenantId);

    User findByIdAndTenantId(Long id,Integer tenantId);

    @Query(value = "select * from user where created_at>=?1 and created_at<?2 and tenant_id=?3 ", nativeQuery = true)
    List<User> findRegisterUserByTimeAndTenantId(String beginTime, String endTime,Integer tenantId);

    @Transactional(rollbackFor = Exception.class)
    @Modifying
    @Query(value = "update user set enable=?1 where phone_no=?2 and tenant_id=?3", nativeQuery = true)
    int forbiddenUserAndTenantId(Boolean enable, String phoneNo,Integer tenantId);

    List<User> findByIdBetweenAndTenantId(Long id, Long endId,Integer tenantId);


    List<User> findByUuidInAndTenantId(List<String> uuids,Integer tenantId);

    /**
     * 根据userId删除用户
     *
     * @param userId 用户id
     */
    void deleteByIdAndTenantId(Long userId,Integer tenantId);
}
