package cn.quantgroup.xyqb.event;

import cn.qg.ec.model.base.BusinessEventBaseInfo;
import cn.qg.ec.model.base.EventInfo;
import cn.qg.ec.model.user.UserBaseInfoEvent;
import cn.quantgroup.user.enums.EducationEnum;
import cn.quantgroup.user.enums.IncomeRangeEnum;
import cn.quantgroup.user.enums.MaritalStatus;
import cn.quantgroup.user.enums.OccupationEnum;
import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.entity.UserExtInfo;
import cn.quantgroup.xyqb.risk.uereventcollecting.UserEventCollectingUtil;
import cn.quantgroup.xyqb.service.user.IUserService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

/**
 * @author ：dongjianhua
 * @date ：Created in 2020/12/22 14:25
 * @description：监听
 * @modified By：
 * @version:
 */
@Slf4j
@Component
public class UserExtInfoSaveEventListener implements ApplicationListener<UserExtInfoSaveEvent> {

    @Autowired
    private IUserService userService;

    @Override
    public void onApplicationEvent(UserExtInfoSaveEvent userExtInfoSaveEvent) {

        UserExtInfo userExtInfo = userExtInfoSaveEvent.getUserExtInfo();

        log.info("用户开始保存扩展信息userExtInfo:{}", userExtInfo);

        EducationEnum educationEnum = userExtInfo.getEducationEnum();
        IncomeRangeEnum incomeRangeEnum = userExtInfo.getIncomeRangeEnum();
        MaritalStatus marryStatus = userExtInfo.getMarryStatus();
        OccupationEnum occupationEnum = userExtInfo.getOccupationEnum();

        User user = userService.findById(userExtInfo.getUserId());
        if (null == user) {
            log.error("没找到用户,应该不存在这种情况");
            return;
        }
        String uuid = user.getUuid();
        if (null != educationEnum) {
            send(UserBaseInfoEvent.SubEventType.user_education, uuid, String.valueOf(educationEnum.ordinal()));
        }
        if (null != incomeRangeEnum) {
            send(UserBaseInfoEvent.SubEventType.user_income, uuid, String.valueOf(incomeRangeEnum.ordinal()));
        }
        if (null != marryStatus) {
            send(UserBaseInfoEvent.SubEventType.user_marital_status, uuid, String.valueOf(marryStatus.ordinal()));
        }
        if (null != occupationEnum) {
            send(UserBaseInfoEvent.SubEventType.user_occupation, uuid, String.valueOf(occupationEnum.ordinal()));
        }
    }

    private void send(UserBaseInfoEvent.SubEventType eventType, String uuid, String val) {

        UserBaseInfoEvent.UserBaseInfoEventBuilder builder = UserBaseInfoEvent.builder();

        BusinessEventBaseInfo.BusinessEventBaseInfoBuilder baseInfoBuilder = BusinessEventBaseInfo.builder();
        baseInfoBuilder.userId(uuid);

        builder.subEventType(eventType);

        switch (eventType) {
            case user_education:
                builder.education(val);
                break;
            case user_income:
                builder.income(val);
                break;
            case user_marital_status:
                builder.maritalStatus(val);
                break;
            case user_occupation:
                builder.occupation(val);
                break;
            default:
                log.warn("没有这个类型");
                return;
        }
        UserEventCollectingUtil.addEvent(builder.build());
    }
}
