package cn.quantgroup.xyqb.repository;

import cn.quantgroup.xyqb.entity.UserTag;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

public interface IUserTagRepository extends JpaRepository<UserTag, Long>, JpaSpecificationExecutor<UserTag> {
    UserTag findByUserIdAndTenantIdAndRegisteredFrom(Long userId, Integer tenantId, Long registeredFrom);

    List<UserTag> findByUserIdInAndTenantId(List<Long> userIds, Integer tenantId);

    @Transactional
    void deleteByUserIdAndTenantId(Long userId, Integer tenantId);
}
