package cn.quantgroup.xyqb.entity;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * 销户记录
 *
 * @author killer
 * @date 2021年12月29日
 **/
@Getter
@Setter
@ToString
@Builder
@Entity
@NoArgsConstructor
@AllArgsConstructor
@Table(name = "user_deregister_record")
public class UserDeregisterRecord implements Serializable {

    private static final long serialVersionUID = -1L;

    /** 主建ID */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Basic(optional = false)
    private Long id;
    /** 用户表ID */
    @Column(name = "user_id")
    private Long userId;
    /** 手机号MD5 */
    @Column(name = "phone_no")
    private String phoneNo;
    /** password */
    @Column(name = "password")
    private String password;
    /** 渠道表ID */
    @Column(name = "registered_from")
    private Long registeredFrom;
    /** uuid */
    @Column(name = "uuid")
    private String uuid;
    /** uuid */
    @Column(name = "deregister_time")
    private Date deregisterTime;
    /** 创建时间 */
    @Column(name = "created_at")
    private Timestamp createdAt;
    /** 更新时间 */
    @Column(name = "updated_at")
    private Timestamp updatedAt;

    @PrePersist
    public void prePersist() {
        Timestamp now = new Timestamp(System.currentTimeMillis());
        this.createdAt = now;
        this.updatedAt = now;
    }

    @PreUpdate
    public void preUpdate() {
        this.updatedAt = new Timestamp(System.currentTimeMillis());
    }

}
