package cn.quantgroup.xyqb.controller.dust;

import cn.quantgroup.xyqb.entity.UserAuthorized;
import cn.quantgroup.xyqb.model.JsonResult;
import cn.quantgroup.xyqb.model.UserAuthorizedParam;
import cn.quantgroup.xyqb.service.auth.IUserAuthorizedService;
import javax.annotation.Resource;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author xufei on 2018/1/5.
 */
@Slf4j
@RestController
@RequestMapping("/user/auth")
public class UserAuthorizedController {

    @Resource
    private IUserAuthorizedService userAuthorizedService;

    /**
     * @Deprecated 20210317
     */
    @Deprecated
    @RequestMapping(value = "/hasUserAuthorized")
    public JsonResult hasUserAuthorized(String idNo) {
        log.info("[hasUserAuthorized]需要校验的用户的身份证号为idNo:{}", idNo);
        if (userAuthorizedService.hasUserAuthorized(idNo)) {
            return JsonResult.buildSuccessResult(null, true);
        } else {
            return JsonResult.buildErrorStateResult(null, false);
        }
    }

    /**
     * @Deprecated 20210317
     */
    @Deprecated
    @RequestMapping(value = "/createUserAuthorized")
    public JsonResult createUserAuthorized(UserAuthorizedParam userAuthorizedParam) {
        log.info("[createUserAuthorized]创建实名账户,userAuthorizedParam:{},", userAuthorizedParam);
        try {
            if (userAuthorizedService.checkUserAuthorizedParam(userAuthorizedParam)) {
                return JsonResult.buildErrorStateResult("参数异常", null);
            }
        } catch (Exception e) {
            log.info("[createUserAuthorized]创建实名账户失败e:{}", e);
            return JsonResult.buildErrorStateResult("参数异常", null);
        }
        UserAuthorized userAuthorized = userAuthorizedService.createUserAuthorized(userAuthorizedParam);
        if (null == userAuthorized) {
            return JsonResult.buildErrorStateResult("重复创建异常或userUuid有误", null);
        } else {
            return JsonResult.buildSuccessResult("创建成功", userAuthorized.getId());
        }
    }

    /**
     * @Deprecated 20210317
     */
    @Deprecated
    @RequestMapping(value = "/getUserAuthorizedId")
    public JsonResult getUserAuthorizedId(String userUuid) {
        log.info("[getUserAuthorizedId]获取实名账户的id，userUuid:{}", userUuid);
        return JsonResult.buildSuccessResult(null, userAuthorizedService.getUserAuthorizedId(userUuid));
    }
}
