package cn.quantgroup.xyqb.service.middleoffice.applet.impl;

import cn.quantgroup.xyqb.controller.middleoffice.login.ILoginModule;
import cn.quantgroup.xyqb.controller.middleoffice.login.LoginVo;
import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.entity.WechatUserInfo;
import cn.quantgroup.xyqb.entity.middleoffice.AppletParamEntry;
import cn.quantgroup.xyqb.exception.AppletException;
import cn.quantgroup.xyqb.repository.IWeChatUserRepository;
import cn.quantgroup.xyqb.service.middleoffice.applet.IAppletService;
import cn.quantgroup.xyqb.service.register.IUserRegisterService;
import cn.quantgroup.xyqb.service.user.IUserService;
import cn.quantgroup.xyqb.util.StringUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import static cn.quantgroup.xyqb.constant.UserConstant.USER_FREEZE_ERROR;

/**
 * @author ：dongjianhua
 * @date ：Created in 2020/5/27 17:27
 * @description：小程序服务层
 * @modified By：
 * @version: 1.0
 */
@Slf4j
@Service
public class AppletServiceImpl implements IAppletService {


    private final IWeChatUserRepository iWeChatUserRepository;

    private final IUserRegisterService iUserRegisterService;

    private final IUserService userService;
    private ILoginModule loginModule;


    @Autowired
    public AppletServiceImpl(IWeChatUserRepository iWeChatUserRepository,
                             IUserRegisterService iUserRegisterService,
                             IUserService userService,
                             ILoginModule loginModule) {
        this.iWeChatUserRepository = iWeChatUserRepository;
        this.iUserRegisterService = iUserRegisterService;
        this.userService = userService;
        this.loginModule = loginModule;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long relevance(AppletParamEntry appletParamEntry) {
        WechatUserInfo wechatUserInfo = iWeChatUserRepository.findByOpenIdAndAppNameAndAppIdAndTenantId(appletParamEntry.getOpenId(), appletParamEntry.getAppName(), appletParamEntry.getAppId(), appletParamEntry.getTenantId());
        //这个接口先不考虑更换手机号的情况

        wechatUserInfo = (wechatUserInfo == null ? new WechatUserInfo() : wechatUserInfo);
        wechatUserInfo.setNickName(appletParamEntry.getNickName());
        wechatUserInfo.setCity(appletParamEntry.getCity());
        wechatUserInfo.setCountry(appletParamEntry.getCountry());
        wechatUserInfo.setProvince(appletParamEntry.getProvince());
        wechatUserInfo.setAppName(appletParamEntry.getAppName());
        wechatUserInfo.setHeadImgUrl(appletParamEntry.getAvatarUrl());
        wechatUserInfo.setLanguage(appletParamEntry.getLanguage());
        wechatUserInfo.setOpenId(appletParamEntry.getOpenId());
        wechatUserInfo.setSex(appletParamEntry.getGender());
        wechatUserInfo.setUnionId(appletParamEntry.getUnionId());
        wechatUserInfo.setPhoneNo(appletParamEntry.getMobile());
        wechatUserInfo.setEncryptedPhoneNo(appletParamEntry.getMobile());
        wechatUserInfo.setUtmSource(appletParamEntry.getUtmSource());
        if (null == wechatUserInfo.getUserId()) {//只要存在userid 就说明已经在用户表里了 不考虑小程序这边换手机号了
            User user = userService.findByPhoneInDb(appletParamEntry.getMobile(), appletParamEntry.getTenantId());
            //如果不存在就去注册一下
            if (null == user) {
                user = iUserRegisterService.register(appletParamEntry.getChannelId(), appletParamEntry.getMobile());
            }
            if (!user.getEnable()) {
                log.warn("已冻结 userId--{}", user.getId());
                throw new AppletException(USER_FREEZE_ERROR, "0402");
            }
            wechatUserInfo.setUserId(user.getId());
        }

        //如果存在就更新在微信表里
        iWeChatUserRepository.save(wechatUserInfo);
        return wechatUserInfo.getUserId();
    }


    @Override
    public LoginVo login(String appName, String openId, Integer tenantId, String utmSource, String unionId, String appId) {
        WechatUserInfo wechatUserInfo;
        if (StringUtils.isEmpty(appId)) {
            wechatUserInfo = iWeChatUserRepository.findByOpenIdAndAppNameAndTenantId(openId, appName, tenantId);
        } else {
            wechatUserInfo = iWeChatUserRepository.findByOpenIdAndAppIdAndTenantId(openId, appId, tenantId);
        }
        if (null == wechatUserInfo) {
            log.warn("未找到此用户,appName:{} ,openId:{}", appName, openId);
            throw new AppletException("未找到此用户", "0401");
        }
        if (null == wechatUserInfo.getUserId()) {
            log.warn("用户未绑定到xyqb,appName:{} ,openId:{}", appName, openId);
            throw new AppletException("未找到此用户绑定信息", "0401");
        }
        User user = userService.findById(wechatUserInfo.getUserId(), wechatUserInfo.getTenantId());
        if (null == user) {
            log.warn("未找到此用户,appName:{} ,openId:{}", appName, openId);
            throw new AppletException("未找到此用户", "0401");
        }

        if (!user.getEnable()) {
            log.warn("已冻结,appName:{} ,openId:{}", appName, openId);
            throw new AppletException(USER_FREEZE_ERROR, "0402");
        }

        if (unionId != null && !unionId.equals(wechatUserInfo.getUnionId())) {
            iWeChatUserRepository.updateUserUnionId(wechatUserInfo.getUserId(), appName, unionId, appId, tenantId);
        }

        return loginModule.loginByUserId(user.getRegisteredFrom(),
                utmSource == null ? "" : utmSource, user.getId(), tenantId);
    }


}
