package cn.quantgroup.xyqb.controller.req.v2;

import cn.quantgroup.xyqb.model.ClientType;
import cn.quantgroup.xyqb.model.SettingType;
import lombok.Data;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.time.LocalDateTime;

@Data
public class BehaviorReq {
    /**
     * 1:极验，2: 量化派图形验证码
     */
    @NotNull
    private Integer type;
    /**
     * 手机号码
     */
    @Size(min = 11,max = 20)
    private String phone;

    /**
     * 0:h5,1:web,2:app
     * @see ClientType
     */
    @NotNull
    private Integer clientType;

    /**
     * 0:账密，1:短验;
     * @see SettingType
     */
    private Integer settingType;

    /**
     * initializeDt,前端传过来，页面初始化极验时间(营销使用)
     */
    private LocalDateTime initializeDt;

    /**
     * 通过request直接取
     */
    private String ip;

}
