package cn.quantgroup.xyqb.controller.api.v2;

import cn.quantgroup.xyqb.controller.req.v2.LoginReq;
import cn.quantgroup.xyqb.model.JsonResult;
import cn.quantgroup.xyqb.model.LoginBean;
import cn.quantgroup.xyqb.service.v2.LoginContext;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/api/v2/oauth")
public class OauthApiV2Controller {
    private final LoginContext loginContext;

    public OauthApiV2Controller(LoginContext loginContext) {
        this.loginContext = loginContext;
    }

    /**
     * 对外内部登录接口
     * @param loginReq LoginReq
     * @return JsonResult<LoginBean>
     * @see <a href="http://yapi.quantgroups.com/project/17/interface/api/65779">对外统一登录接口</a>
     */
    @PostMapping("/login")
    public JsonResult<LoginBean> login(@RequestBody LoginReq loginReq){
        return JsonResult.buildSuccessResultGeneric(loginContext.login(loginReq));
    }
}
