package cn.quantgroup.xyqb.thirdparty.jcaptcha;

import com.octo.captcha.image.ImageCaptcha;
import org.apache.commons.lang3.StringUtils;

import java.awt.image.BufferedImage;

/**
 * 类名称：SimpleCaptcha
 * 类描述：
 *
 * @author 李宁
 * @version 1.0.0
 *          创建时间：15/12/17 08:47
 *          修改人：
 *          修改时间：15/12/17 08:47
 *          修改备注：
 */
public class SimpleCaptcha extends ImageCaptcha {

    private String response;

    public SimpleCaptcha(String question, String response) {
        this(question, null, response);
    }

    public SimpleCaptcha(String question, BufferedImage challenge, String response) {
        super(question, challenge);
        this.response = response;
    }

    public final Boolean validateResponse(Object response) {
        return null != response && response instanceof String ? this.validateResponse((String) response) : Boolean.FALSE;
    }

    private Boolean validateResponse(String response) {
        return StringUtils.equals(this.response, response);
    }

    public String getResponse() {
        return response;
    }

    public void setResponse(String response) {
        this.response = response;
    }
}
