package cn.quantgroup.xyqb.controller;

import cn.quantgroup.xyqb.exception.NullUserException;
import cn.quantgroup.xyqb.exception.UserNotExistException;
import cn.quantgroup.xyqb.exception.VerificationCodeErrorException;
import cn.quantgroup.xyqb.model.JsonResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;

/**
 * Created by Miraculous on 15/7/6.
 * 出现异常，进入这个handler。
 */
@ControllerAdvice
@RestController
public class ExceptionHandlingController implements IBaseController {

    private static final Logger LOGGER = LoggerFactory.getLogger(ExceptionHandlingController.class);


    private static final JsonResult EXCEPTION_RESULT = new JsonResult("internal error", 500L, "");

    @ExceptionHandler(NullUserException.class)
    @ResponseStatus(HttpStatus.UNAUTHORIZED)
    public JsonResult nullUserException(NullUserException nue) {
        return new JsonResult(nue.getMessage(), 401L, null);
    }

    /**
     * 验证码登陆异常
     *
     * @param vce
     * @return
     */
    @ExceptionHandler(VerificationCodeErrorException.class)
    public JsonResult verificationCodeErrorException(VerificationCodeErrorException vce) {
        return JsonResult.buildErrorStateResult(vce.getMessage(), null, 1L);
    }

    @ExceptionHandler(UserNotExistException.class)
    @ResponseStatus(HttpStatus.UNAUTHORIZED)
    public JsonResult userNotExistException(UserNotExistException unee) {
        return new JsonResult(unee.getMessage(), 401L, null);
    }



    @ExceptionHandler(Exception.class)
    public JsonResult exceptionOccurs(Exception e) {
        HttpServletRequest request = getRequest();
        String uri = request.getRequestURI();
        String registerFrom = request.getParameter("registerFrom");
        LOGGER.error("接口异常 URI:{}, registerFrom:{}", uri, registerFrom, e);
        return EXCEPTION_RESULT;
    }
}
