package cn.quantgroup.xyqb.config.data;

/**
 * Created by Miraculous on 2016/11/16.
 */

import cn.quantgroup.cloudconfig.SafeValue;
import cn.quantgroup.xyqb.util.ApplicationContextHolder;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.vendor.Database;
import org.springframework.orm.jpa.vendor.HibernateJpaVendorAdapter;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import java.util.Properties;

/**
 * Created by Miraculous on 2016/11/14.
 */
@Configuration
@EnableJpaRepositories(basePackages = "cn.quantgroup.xyqb.repository")
@EnableTransactionManagement
public class JpaConfig {

    @SafeValue("xyqb.data.mysql.jdbc-url")
    private String xyqbJdbcUrl;

    @SafeValue("xyqb.data.mysql.password")
    private String password;

    @SafeValue("xyqb.data.mysql.user")
    private String user;

    @Value("${xyqb.data.mysql.max-pool-size}")
    private Integer maxPoolSize;

    @Bean
    @DependsOn(value = "dataSource")
    public EntityManagerFactory entityManagerFactory() {
        LocalContainerEntityManagerFactoryBean entityManager = new LocalContainerEntityManagerFactoryBean();
        entityManager.setDataSource(ApplicationContextHolder.getBean("dataSource"));
        entityManager.setPackagesToScan("cn.quantgroup.xyqb");
        entityManager.setPersistenceUnitName("dataSource");
        Properties properties = new Properties();
        properties.put("hibernate.jdbc.batch_size", 30);
        properties.put("hibernate.order_inserts", true);
        properties.put("hibernate.order_updates", true);
        entityManager.setJpaProperties(properties);
        entityManager.setJpaVendorAdapter(jpaVendorAdapter());
        entityManager.afterPropertiesSet();
        return entityManager.getObject();
    }

    @Bean
    public DataSource dataSource() {
        HikariConfig config = new HikariConfig();
        config.setJdbcUrl(xyqbJdbcUrl);
        config.setPassword(password);
        config.setUsername(user);
        config.setMaximumPoolSize(maxPoolSize);
        config.setMinimumIdle(20);
        config.addDataSourceProperty("cachePrepStmts", "true");
        config.addDataSourceProperty("prepStmtCacheSize", "250");
        config.addDataSourceProperty("prepStmtCacheSqlLimit", "2048");
        return new HikariDataSource(config);

    }


    private JpaVendorAdapter jpaVendorAdapter() {
        HibernateJpaVendorAdapter hibernateJpaVendorAdapter = new HibernateJpaVendorAdapter();
        hibernateJpaVendorAdapter.setShowSql(false);
        hibernateJpaVendorAdapter.setGenerateDdl(false);
        hibernateJpaVendorAdapter.setDatabase(Database.MYSQL);
        return hibernateJpaVendorAdapter;
    }



    @Bean
    public PlatformTransactionManager transactionManager(EntityManagerFactory entityManagerFactory) {
        JpaTransactionManager transactionManager = new JpaTransactionManager();
        transactionManager.setEntityManagerFactory(entityManagerFactory);
        return transactionManager;
    }

}
