package cn.quantgroup.xyqb.model;

import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.entity.WechatUserInfo;
import lombok.Data;
import org.apache.commons.collections.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

@Data
public class UserBean {
    private Long userId;
    private String openId;
    private String appId;
    private String unionId;
    private String phoneNo;

    private Long registeredFrom;

    private String uuid;

    private Boolean enable;
    private Integer tenantId;


    public static UserBean from(User user, WechatUserInfo wechatUserInfo) {
        UserBean userBean = new UserBean();
        userBean.setUserId(user.getId());
        userBean.setPhoneNo(user.getPhoneNo());
        userBean.setRegisteredFrom(user.getRegisteredFrom());
        userBean.setUuid(user.getUuid());
        userBean.setEnable(user.getEnable());
        userBean.setTenantId(user.getTenantId());
        if (wechatUserInfo != null) {
            userBean.setOpenId(wechatUserInfo.getOpenId());
            userBean.setUnionId(wechatUserInfo.getUnionId());
            userBean.setAppId(wechatUserInfo.getAppId());
        }
        return userBean;
    }

    public static List<UserBean> from(List<User> userList, List<WechatUserInfo> wechatUserInfoList) {
        List<UserBean> result = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(userList)) {
            userList.forEach(user -> {
                UserBean userBean = new UserBean();
                userBean.setUserId(user.getId());
                userBean.setPhoneNo(user.getPhoneNo());
                userBean.setRegisteredFrom(user.getRegisteredFrom());
                userBean.setUuid(user.getUuid());
                userBean.setEnable(user.getEnable());
                userBean.setTenantId(user.getTenantId());
                if (CollectionUtils.isNotEmpty(wechatUserInfoList)) {
                    Optional<WechatUserInfo> optionalWechatUserInfo = wechatUserInfoList.stream().filter(i -> i.getUserId().equals(user.getId())).findFirst();

                    if (optionalWechatUserInfo.isPresent()) {
                        WechatUserInfo wechatUserInfo = optionalWechatUserInfo.get();
                        userBean.setOpenId(wechatUserInfo.getOpenId());
                        userBean.setUnionId(wechatUserInfo.getUnionId());
                        userBean.setAppId(wechatUserInfo.getAppId());
                    }
                }
                result.add(userBean);
            });
        }
        return result;
    }
}
