package cn.quantgroup.xyqb.event;

import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.entity.WechatUserInfo;
import cn.quantgroup.xyqb.repository.IUserRepository;
import cn.quantgroup.xyqb.repository.IWeChatUserRepository;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * user_tag表，用来监听
 */
@Component
public class WechatBindingEventListener implements ApplicationListener<UserLoginEvent> {

    @Autowired
    private IUserRepository userRepository;
    @Autowired
    private IWeChatUserRepository weChatUserRepository;

    /**
     * 进行用户表和微信表关联，通过手机号码和租户号
     *
     * @param userLoginEvent UserLoginEvent
     */
    @Override
    public void onApplicationEvent(UserLoginEvent userLoginEvent) {
        if (userLoginEvent.getUserTag() != null) {
            User user = userRepository.findByIdAndTenantId(userLoginEvent.getUserTag().getUserId(), userLoginEvent.getUserTag().getTenantId());
            if (user != null && StringUtils.isNotEmpty(user.getPhoneNo())) {
                List<WechatUserInfo> wechatUserInfoList = weChatUserRepository.findByPhoneNoAndTenantId(user.getPhoneNo(), user.getTenantId());
                wechatUserInfoList.forEach(i -> i.setUserId(user.getId()));
                if (CollectionUtils.isNotEmpty(wechatUserInfoList)) {
                    weChatUserRepository.save(wechatUserInfoList);
                }
            }

        }
    }
}
