package cn.quantgroup.xyqb.exception;

import lombok.Data;

/**
 * Created by Miraculous on 15/7/11.
 */
@Data
public class VerificationCodeErrorException extends RuntimeException {

    private static final long serialVersionUID = -1L;
    private String msg;
    private String businessCode;

    public VerificationCodeErrorException() {
        super("验证码错误");
    }

    public VerificationCodeErrorException(String message) {
        super(message);
    }

    public VerificationCodeErrorException(BizExceptionEnum bizExceptionEnum) {
        super(bizExceptionEnum.getMsg());
        this.msg = bizExceptionEnum.getMsg();
        this.businessCode = bizExceptionEnum.getBusinessCode();
    }

    public VerificationCodeErrorException(BizExceptionEnum bizExceptionEnum,String attach) {
        this.msg = bizExceptionEnum.getMsg()+attach;
        this.businessCode = bizExceptionEnum.getBusinessCode();
    }

}
