package cn.quantgroup.xyqb.repository;


import cn.quantgroup.xyqb.entity.WechatUserInfo;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

/**
 * Created by 11 on 2017/1/18.
 */
public interface IWeChatUserRepository extends JpaRepository<WechatUserInfo, Long> {
  WechatUserInfo findByOpenId(String openId);

  WechatUserInfo findByPhoneNo(String phoneNo);

  WechatUserInfo findByUserId(Long userId);

  long countByOpenId(String openId);

  @Transactional
  @Modifying
  int removeByUserId(Long userId);

  @Transactional
  @Modifying
  @Query(value = "update wechat_userinfo set user_id=?1,phone_no=?2 where open_id=?3 and user_id is null", nativeQuery = true)
  int bindingUser(Long userId, String phoneNo, String openId);
}
