package cn.quantgroup.xyqb.aspect.accessable;

import cn.quantgroup.xyqb.Constants;
import cn.quantgroup.xyqb.model.JsonResult;
import cn.quantgroup.xyqb.util.IPUtil;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import javax.xml.crypto.dsig.keyinfo.PGPData;
import java.util.Objects;

/**
 * IP白名单检验
 *
 * @author renwc
 * @date 2017-12-01
 */
@Aspect
@Component
public class IpValidateAdvisor {
    private static final Logger LOGGER = LoggerFactory.getLogger(IpValidateAdvisor.class);

    @Autowired
    @Qualifier("stringRedisTemplate")
    private RedisTemplate<String, String> redisTemplate;

    @Value("${configserver.disable}")
    private Integer isDebug;

    @Pointcut("execution(public * cn.quantgroup.xyqb.controller.external.user.InnerController.*(..))")
    private void whiteIpMatch() {
    }

    @Around("whiteIpMatch()")
    private Object doWhiteIpMatch(ProceedingJoinPoint pjp) throws Throwable {
        if(Objects.equals(isDebug, 0)){
            return pjp.proceed();
        }
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        // 客户端IP
        String clientIp = IPUtil.getRemoteIP(request);
        // 白名单
        if(IPUtil.whiteOf(clientIp)){
            return pjp.proceed();
        }
        // 补充白名单
        if(redisTemplate.opsForSet().isMember(Constants.IPV4_LOCK_WHITE, clientIp)){
            return pjp.proceed();
        }
        IPUtil.logIp(LOGGER, request);
        LOGGER.error("Lock_ipv4: don't match white ip access:{}", clientIp);
        return JsonResult.buildErrorStateResult("非法访问", null);
    }

    @Pointcut("@annotation(cn.quantgroup.xyqb.aspect.accessable.IpValidator)")
    private void needIpValidate() {
    }

    @Before("needIpValidate()")
    private void doCapchaValidate() throws Throwable {
    }
}
