package cn.quantgroup.xyqb.service.v2;

import cn.quantgroup.xyqb.controller.req.v2.BehaviorReq;
import cn.quantgroup.xyqb.controller.req.v2.ValidateBehavior;
import cn.quantgroup.xyqb.exception.BizException;
import cn.quantgroup.xyqb.exception.BizExceptionEnum;
import cn.quantgroup.xyqb.model.BehaviorCodeBean;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
public class BehaviorContext {

    private final Map<Integer,BehaviorStrategy> behaviorStrategyMap = new HashMap<>();

    public BehaviorContext(List<LoginStrategy> loginStrategies, List<BehaviorStrategy> behaviorStrategies) {
        behaviorStrategies.forEach(i->behaviorStrategyMap.put(i.getType(), i));
    }

    public BehaviorCodeBean generate(BehaviorReq behaviorReq){
        BehaviorStrategy behaviorStrategy = behaviorStrategyMap.get(behaviorReq.getType());
        if(behaviorStrategy == null){
            throw  new BizException(BizExceptionEnum.UN_EXIT_VERIFY_TYPE);
        }
        return behaviorStrategy.generate(behaviorReq);
    }

    public boolean validate(ValidateBehavior validateBehavior){
        BehaviorStrategy behaviorStrategy = behaviorStrategyMap.get(validateBehavior.getType());
        if(behaviorStrategy == null){
            throw  new BizException(BizExceptionEnum.UN_EXIT_VERIFY_TYPE);
        }
        return behaviorStrategy.validate(validateBehavior);
    }

}
