package cn.quantgroup.xyqb.entity;

import cn.quantgroup.motan.retbean.XUserExtInfo;
//import cn.quantgroup.xyqb.entity.enumerate.*;
import cn.quantgroup.user.enums.*;
import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.sql.Timestamp;

/**
 * Created by 11 on 2016/12/30.
 */
@Data
@Entity
@Table(name = "user_ext_info")
public class UserExtInfo implements Serializable {

  private static final long serialVersionUID = -1L;
  @Id
  @GeneratedValue(strategy = GenerationType.IDENTITY)
  @Column(name = "id")
  private Long id;
  @Column(name = "user_id")
  private Long userId;
  @Column(name = "means_of_income_payment")
  private IncomeEnum incomeEnum = IncomeEnum.UNKNOWN;
  @Column(name = "monthly_income_range")
  private IncomeRangeEnum incomeRangeEnum = IncomeRangeEnum.UNKNOWN;
  @Column(name = "occupation")
  private OccupationEnum occupationEnum = OccupationEnum.UNKNOWN;
  @Column(name = "education")
  private EducationEnum educationEnum = EducationEnum.UNKNOWN;
  @Column(name = "has_car")
  private Boolean hasCar = false;
  @Column(name = "has_social_security")
  private Boolean hasSocialSecurity = false;
  @Column(name = "has_house")
  private Boolean hasHouse = false;
  @Column(name = "has_credit_card")
  private Boolean hasCreditCard = false;
  @Column(name = "marry_status")
  private MaritalStatus marryStatus = MaritalStatus.UNKNOWN;
  @Column(name = "created_at")
  private Timestamp createdAt;
  @Column(name = "updated_at")
  private Timestamp updateAt;

  public XUserExtInfo toXUserExtInfo(){
    XUserExtInfo xUserExtInfo = new XUserExtInfo();
    xUserExtInfo.setId(this.id);
    xUserExtInfo.setUserId(this.userId);
    xUserExtInfo.setEducationEnum(cn.quantgroup.motan.enums.EducationEnum.valueOf(this.educationEnum.name()));
    xUserExtInfo.setIncomeEnum(cn.quantgroup.motan.enums.IncomeEnum.valueOf(this.incomeEnum.name()));
    xUserExtInfo.setIncomeRangeEnum(cn.quantgroup.motan.enums.IncomeRangeEnum.valueOf(this.incomeRangeEnum.name()));
    xUserExtInfo.setOccupationEnum(cn.quantgroup.motan.enums.OccupationEnum.valueOf(this.occupationEnum.name()));
    xUserExtInfo.setHasCar(this.hasCar);
    xUserExtInfo.setHasSocialSecurity(this.hasSocialSecurity);
    xUserExtInfo.setHasCreditCard(this.hasCreditCard);
    xUserExtInfo.setMarryStatus(cn.quantgroup.motan.enums.MaritalStatus.valueOf(this.marryStatus.name()));
    xUserExtInfo.setCreatedAt(this.createdAt);
    xUserExtInfo.setUpdateAt(this.updateAt);
    return xUserExtInfo;
  }
}
