package cn.quantgroup.xyqb.service.v2;

import cn.quantgroup.xyqb.controller.req.v2.LoginReq;
import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.entity.UserInfoEntity;
import cn.quantgroup.xyqb.entity.UserTag;
import cn.quantgroup.xyqb.entity.WechatUserInfo;
import cn.quantgroup.xyqb.event.UserLoginEvent;
import cn.quantgroup.xyqb.exception.BizException;
import cn.quantgroup.xyqb.exception.BizExceptionEnum;
import cn.quantgroup.xyqb.model.LoginBean;
import cn.quantgroup.xyqb.model.UserInfo;
import cn.quantgroup.xyqb.model.session.SessionStruct;
import cn.quantgroup.xyqb.model.v2.login.BaseLoginParam;
import cn.quantgroup.xyqb.repository.IUserInfoRepository;
import cn.quantgroup.xyqb.repository.IUserRepository;
import cn.quantgroup.xyqb.service.wechat.IWechatService;
import cn.quantgroup.xyqb.session.XyqbSessionContextHolder;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
public class LoginContext {
    private final ApplicationEventPublisher applicationEventPublisher;

    private final IUserRepository userRepository;

    private final IUserInfoRepository userInfoRepository;

    private final Map<Integer, LoginStrategy> interloginStrategyMap = new HashMap<>();

    public LoginContext(List<LoginStrategy> loginStrategies, ApplicationEventPublisher applicationEventPublisher, IWechatService wechatService, IUserRepository userRepository, IUserInfoRepository userInfoRepository) {
        this.applicationEventPublisher = applicationEventPublisher;
        this.userRepository = userRepository;
        this.userInfoRepository = userInfoRepository;
        loginStrategies.forEach(i -> interloginStrategyMap.put(i.getType(), i));
    }

    public LoginBean login(LoginReq loginReq) {
        if (loginReq.getType() != null && loginReq.getType() == 9000) {
            throw new BizException(BizExceptionEnum.ERROR_INTERNAL_LOGIN);
        }
        return this.interLogin(loginReq);
    }


    /**
     * 内部统一登录
     *
     * @param loginReq LoginReq
     * @return LoginBean
     */
    public LoginBean interLogin(LoginReq loginReq) {

        //第一步、校验参数
        LoginStrategy loginStrategy = interloginStrategyMap.get(loginReq.getType());
        BaseLoginParam loginParam = loginStrategy.checkParam(loginReq);


        //第二步、执行登录操作
        LoginBean loginBean = loginStrategy.login(loginParam);


        //第三步、发送登录成功消息
        SessionStruct sessionStruct = XyqbSessionContextHolder.getXSession();
        Long registeredFrom = sessionStruct.getRegisteredFrom();
        if (sessionStruct.getValues() != null && sessionStruct.getValues().getLoginProperties() != null) {
            registeredFrom = sessionStruct.getValues().getLoginProperties().getCreatedFrom();
        }

        UserTag userTag = UserTag.builder().userId(loginBean.getUserId()).registeredFrom(registeredFrom).tenantId(sessionStruct.getTenantId()).build();
        String geetestId = null;
        if (StringUtils.isNotEmpty(sessionStruct.getGeetestId())) {
            geetestId = sessionStruct.getGeetestId();
        }

        UserLoginEvent userLoginEvent = new UserLoginEvent(this, userTag, geetestId);
        applicationEventPublisher.publishEvent(userLoginEvent);


        //第四步，补充相关信息
        if (loginBean.getUserId() != null) {
            User user = userRepository.findByIdAndTenantId(loginBean.getUserId(), loginBean.getTenantId());

            if (loginReq.isAttachInfo()) {
                UserInfoEntity userInfoEntity = userInfoRepository.findByUserIdAndTenantId(loginBean.getUserId(), loginBean.getTenantId());
                loginBean.setInfo(new UserInfo(user, userInfoEntity));
            }
        }


        return loginBean;
    }
}
