package cn.quantgroup.xyqb.model;

import java.util.Optional;

/**
 * 验证场景类型
 */
public enum SettingType {
    PASSWD("账密"), SMSLOGIN("短验");

    SettingType(String alias) {
        this.alias = alias;
    }

    private final String alias;

    public String getAlias() {
        return this.alias;
    }

    public static SettingType valueByName(String name) {
        name = Optional.ofNullable(name).orElse("").toLowerCase();
        if ("短验".equals(name)) {
            return SMSLOGIN;
        }
        return PASSWD;
    }


    public static SettingType valueByCode(Integer code) {
        if (code != null && code == 1) {
            return SMSLOGIN;
        }
        return PASSWD;
    }

}
