package cn.quantgroup.xyqb.entity;

import cn.quantgroup.xyqb.entity.enums.ApplySource;
import cn.quantgroup.xyqb.entity.enums.Reason;
import cn.quantgroup.xyqb.util.encrypt.CryptConverter;
import javax.persistence.Convert;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * Created by 11 on 2017/3/22.
 */
@Data
@Entity
@Table(name = "user_modify_phone_record")
public class UserModifyPhoneRecord  extends BaseEntity implements Serializable {

    @Column(name = "user_id")
    private Long userId;

    @Column(name = "prev_phone_no")
    @Convert(converter = CryptConverter.class)
    private String prevPhoneNo;

    @Column(name = "cur_phone_no")
    @Convert(converter = CryptConverter.class)
    private String curPhoneNo;

    @Column(name = "reason")
    private Reason reason;

    @Column(name = "operator")
    private String operator;

    @Column(name = "remark")
    private String remark;

    @Column(name = "financial_response")
    private String financialResponse;

    /**
     * 申请来源
     */
    @Column(name = "apply_source")
    private ApplySource applySource;

    /**
     * 申请状态 0处理中; 1修改完成; 2不允许修改;
     */
    @Column(name = "apply_status")
    private Integer applyStatus;

    /**
     * 申请状态补充原因
     */
    @Column(name = "apply_status_reason")
    private String applyStatusReason;
}
