package cn.quantgroup.xyqb.service.v2;

import cn.quantgroup.xyqb.Constants;
import cn.quantgroup.xyqb.controller.req.v2.BehaviorReq;
import cn.quantgroup.xyqb.controller.req.v2.ValidateBehavior;
import cn.quantgroup.xyqb.entity.GeetestLogEntity;
import cn.quantgroup.xyqb.exception.BizException;
import cn.quantgroup.xyqb.exception.BizExceptionEnum;
import cn.quantgroup.xyqb.model.BehaviorCodeBean;
import cn.quantgroup.xyqb.model.ClientType;
import cn.quantgroup.xyqb.model.SettingType;
import cn.quantgroup.xyqb.service.captcha.IGeetestCaptchaService;
import cn.quantgroup.xyqb.service.captcha.IGeetestLogService;
import cn.quantgroup.xyqb.service.captcha.IQuantgroupCaptchaService;
import cn.quantgroup.xyqb.util.PasswordUtil;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;

/**
 * 极验模式
 */
@Service
public class GeetestBehaviorStrategy implements BehaviorStrategy {
    private final IGeetestCaptchaService geetestCaptchaService;
    private final IGeetestLogService geetestLogService;

    private final IQuantgroupCaptchaService quantgroupCaptchaService;

    public GeetestBehaviorStrategy(IGeetestCaptchaService geetestCaptchaService, IGeetestLogService geetestLogService, IQuantgroupCaptchaService quantgroupCaptchaService) {
        this.geetestCaptchaService = geetestCaptchaService;
        this.geetestLogService = geetestLogService;
        this.quantgroupCaptchaService = quantgroupCaptchaService;
    }

    @Override
    public Integer getType() {
        return 1;
    }

    @Override
    public boolean validate(ValidateBehavior validateBehavior) {
        GeetestLogEntity geetestLogEntity = geetestLogService.getById(Long.valueOf(validateBehavior.getData().get(Constants.X_BEHAVIOR_ID)));
        if (geetestLogEntity == null) {
            throw new BizException(BizExceptionEnum.UN_EXIT_GEETEST_LOG);
        }
        Map<String, Object> result;

        String key = StringUtils.isNotBlank(geetestLogEntity.getPhoneNo()) ? geetestLogEntity.getPhoneNo().trim() : UUID.randomUUID().toString();

        if (SettingType.PASSWD.getAlias().equals(SettingType.valueByCode(geetestLogEntity.getSetting()).getAlias())) {
            result = geetestCaptchaService.validGeetestCaptchaPasswd(key, validateBehavior.getData().get(Constants.X_BEHAVIOR_IP), ClientType.valueByCode(geetestLogEntity.getDataSource()), validateBehavior.getData().get(Constants.X_BEHAVIOR_CHALLENGE), validateBehavior.getData().get(Constants.X_BEHAVIOR_VALIDATE), validateBehavior.getData().get(Constants.X_BEHAVIOR_SECCODE));
        } else {
            result = geetestCaptchaService.validGeetestCaptcha(key, validateBehavior.getData().get(Constants.X_BEHAVIOR_IP), ClientType.valueByCode(geetestLogEntity.getDataSource()), validateBehavior.getData().get(Constants.X_BEHAVIOR_CHALLENGE), validateBehavior.getData().get(Constants.X_BEHAVIOR_VALIDATE), validateBehavior.getData().get(Constants.X_BEHAVIOR_SECCODE));
        }
        geetestLogService.updateGeetestLog(validateBehavior.getData().get(Constants.X_BEHAVIOR_ID), null, null, null, result);

        return (boolean) result.get("valid");
    }


    @Override
    public BehaviorCodeBean generate(BehaviorReq behaviorReq) {
        BehaviorCodeBean behaviorCodeBean = new BehaviorCodeBean();
        String key = StringUtils.isNotBlank(behaviorReq.getPhone()) ? behaviorReq.getPhone().trim() : UUID.randomUUID().toString();
        // key指纹
        String registerDt = LocalDateTime.now().toString();
        Map<String, String> imgMap;
        //0:账密，1:短验;
        if (behaviorReq.getSettingType() == 0) {
            imgMap = geetestCaptchaService.fetchGeetestCaptchaPasswd(PasswordUtil.MD5(key), behaviorReq.getIp(), ClientType.valueByCode(behaviorReq.getClientType()));
        } else {
            imgMap = geetestCaptchaService.fetchGeetestCaptcha(PasswordUtil.MD5(key), behaviorReq.getIp(), ClientType.valueByCode(behaviorReq.getClientType()));
        }

        if (imgMap.containsKey("success") && "1".equals(imgMap.get("success"))) {
            behaviorCodeBean.setType(1);
            behaviorCodeBean.setGeetestCode(BehaviorCodeBean.GeetestCode.builder().gt(imgMap.get("gt"))
                    .challenge(imgMap.get("challenge"))
                    .reChallenge(imgMap.get("reChallenge")
                    ).offline(false).newCaptcha(true).
                    build());
            String registerReDt = LocalDateTime.now().toString();
            imgMap.put(Constants.QG_CAPTCHA_INITDT, behaviorReq.getInitializeDt() == null ? LocalDateTime.now().toString() : behaviorReq.getInitializeDt().toString());
            imgMap.put(Constants.QG_CAPTCHA_REGISTERDT, registerDt);
            imgMap.put(Constants.QG_CAPTCHA_REGISTERREDT, registerReDt);

            Long geetestLogId = geetestLogService.saveGeetestLog(behaviorReq.getPhone(), ClientType.valueByCode(behaviorReq.getClientType()).getAlias(), SettingType.valueByCode(behaviorReq.getSettingType()).getAlias(), imgMap);
            behaviorCodeBean.setId(String.valueOf(geetestLogId));
        } else {
            //降级方案
            behaviorCodeBean.setType(2);
            imgMap = quantgroupCaptchaService.fetchQuantgroupCaptcha(Locale.CHINA);
            if (imgMap != null) {
                behaviorCodeBean.setQtCode(BehaviorCodeBean.QtCode.builder()
                        .imageData(imgMap.get("image")).build());
                behaviorCodeBean.setId(imgMap.get("imageId"));
            } else {
                throw new BizException(BizExceptionEnum.EX_GET_VERIFY_CODE);
            }

        }
        return behaviorCodeBean;
    }
}
