package cn.quantgroup.xyqb.controller.external.user;

import cn.quantgroup.xyqb.Constants;
import cn.quantgroup.xyqb.controller.IBaseController;
import cn.quantgroup.xyqb.entity.Merchant;
import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.entity.WechatUserInfo;
import cn.quantgroup.xyqb.event.UserinfoChangedEvent;
import cn.quantgroup.xyqb.model.AuthBean;
import cn.quantgroup.xyqb.model.JsonResult;
import cn.quantgroup.xyqb.model.webchat.AccessTokenResponse;
import cn.quantgroup.xyqb.service.merchant.IMerchantService;
import cn.quantgroup.xyqb.service.page.IPageService;
import cn.quantgroup.xyqb.service.session.ISessionService;
import cn.quantgroup.xyqb.service.user.IUserService;
import cn.quantgroup.xyqb.service.wechat.IWechatService;
import cn.quantgroup.xyqb.util.EmojiUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;

/**
 * Created by 11 on 2017/1/17.
 */
@Slf4j
@RestController
@RequestMapping("/wechat")
public class WeChatController implements IBaseController {

    private static final Logger LOGGER = LoggerFactory.getLogger(WeChatController.class);

    // todo: 配置文件
    private static final String TOKEN = "5YihkluEo5QuWAWpFwzvA";

    @Autowired
    private IWechatService wechatService;

    @Autowired
    private IMerchantService merchantService;

    @Autowired
    private ISessionService sessionService;

    @Autowired
    private IUserService userService;

    @Autowired
    private IPageService pageService;

    // https://passport.xyqb.com/landing?key=xxx&target=cashTarget5&registerFrom=198&channelId=%d
    @Value("${xyqb-user.ui}")
    private String userUIAddr;


    /**
     * 开发者资质认证,有必要吗?
     *
     * @param request
     * @return
     */
    @RequestMapping("/checkValid")
    public String valid(HttpServletRequest request) {
        String echoStr = request.getParameter("echostr");
        if (checkSignature(request)) {
            return echoStr;
        }
        return "";
    }

    /**
     * 微信登录
     *
     * @param name         姓名
     * @param idNo         身份证号
     * @param phoneNo      手机号
     * @param registerFrom ${registerFrom}
     * @param channelId    ${channelId}
     * @param appChannel   ${appChanel}
     * @param key          "xyqb"
     * @return
     */
    public JsonResult webChatLogin(String name, String idNo, String phoneNo, String registerFrom,
                                   String channelId, String appChannel, String key) {
        if (StringUtils.isBlank(name) || StringUtils.isBlank(idNo) || StringUtils.isBlank(phoneNo)) {
            return JsonResult.buildErrorStateResult("请填写完整的用户信息.", null);
        }
        if (StringUtils.isBlank(key)) {
            return JsonResult.buildErrorStateResult("无效的商户信息.", null);
        }
        return null;
    }


    /**
     * 验签：步骤
     * 1.获取signature, timestamp, nonce三个参数
     * 2.用timestamp, nonce, token三个参数做字符升序排列
     * 3.将排列好的字符串进行sha1加密,和signature参数做比较
     * 4.相等返回true,否则返回false
     *
     * @param request
     * @return
     */
    private boolean checkSignature(HttpServletRequest request) {
        String signature = request.getParameter("signature");
        String timestamp = request.getParameter("timestamp");
        String nonce = request.getParameter("nonce");
        String token = TOKEN;
        String[] arrs = new String[]{token, timestamp, nonce};
        Arrays.sort(arrs);
        String joinStr = joinArray(arrs);
        joinStr = sha1(joinStr);
        return joinStr.equals(signature);
    }

    /**
     * sha1加密算法,
     *
     * @param decript
     * @return 返回40位16进制字符串
     */
    public String sha1(String decript) {
        try {
            MessageDigest digest = java.security.MessageDigest
                    .getInstance("SHA-1");
            digest.update(decript.getBytes());
            byte messageDigest[] = digest.digest();
            StringBuffer hexString = new StringBuffer();
            // 字节数组转换为十六进制数
            for (int i = 0; i < messageDigest.length; i++) {
                String shaHex = Integer.toHexString(messageDigest[i] & 0xFF);
                if (shaHex.length() < 2) {
                    hexString.append(0);
                }
                hexString.append(shaHex);
            }
            return hexString.toString();

        } catch (NoSuchAlgorithmException e) {
            log.error("未找到sha1算法." + e.getMessage());
        }
        return "";
    }

    /**
     * 数组分割为字符串
     *
     * @param arr
     * @return
     */
    private String joinArray(String[] arr) {
        StringBuilder builder = new StringBuilder();
        for (String str : arr) {
            builder.append(str);
        }
        return builder.toString();
    }


    /**
     * 通过redirect_url获取code
     *
     * @param response
     * @return
     */
    @RequestMapping("/receiveCode/{key}/{redirect}")
    public void receiveCode(
      String code, @PathVariable(value = "key") String systemKey,
      @PathVariable String redirect, HttpServletRequest request, HttpServletResponse response) {
        String schema = request.getScheme();
        LOGGER.info("HTTP协议:" + schema);
        // 从code获取token
        Merchant merchant = merchantService.findMerchantByName(systemKey);

        AccessTokenResponse token = wechatService.getToken(code);
        if (token == null) {
            // 让用户登录，不关联微信, 构造不关联微信的url
            redirectNormalUrl(response, merchant, Constants.Channel.WECHAT);
            return;
        }
        WechatUserInfo userInfo = wechatService.getWechatUserInfoFromWechatServer(token.getAccessToken(), token.getOpenId());
        if (userInfo == null || StringUtils.isEmpty(userInfo.getOpenId())) {
            // 让用户登录，不关联微信, 构造不关联微信的url
            redirectNormalUrl(response, merchant, Constants.Channel.WECHAT);
            return;
        }
        WechatUserInfo userInfoInDb = wechatService.findWechatUserInfoFromDb(userInfo.getOpenId());
        // welcome 首次登录
        if (userInfoInDb == null) {
            // 微信用户首次登录界面, 首先保存userInfo, 跳入到微信注册登录界面
            if(StringUtils.isNotBlank(userInfo.getNickName())) {
                String nickName = EmojiUtil.filter(userInfo.getNickName());
                userInfo.setNickName(nickName);
            }
            userInfo = wechatService.saveWechatUserInfo(userInfo);
            redirectWechatLoginUrlWithoutLogin(response, merchant, userInfo, Constants.Channel.WECHAT);
            return;
        }
        if (userInfoInDb.getUserId() == null) {
            // 用户已经微信登录了，但是没有关联信用钱包，跳转到注册页面
            redirectWechatLoginUrlWithoutLogin(response, merchant, userInfoInDb, Constants.Channel.WECHAT);
            return;
        }
        User user = userService.findById(userInfoInDb.getUserId());
        if (user == null) {
            redirectWechatLoginUrlWithoutLogin(response, merchant, userInfoInDb, Constants.Channel.WECHAT);
            return;
        }
        // 已经关联了用户
        // create session, 登进去，该怎么玩怎么玩。
        String redirectUrl = createUserSession(user, merchant, redirect, schema, Constants.Channel.WECHAT);
        response.setHeader("Location", redirectUrl);
        response.setStatus(301);
    }



  /**
   * 前端微信跳转页面，通过extdata
   *
   * @param response
   * @return
   */
  @RequestMapping("/receiveCode/extdata/{key}/{extdata}")
  public void receiveCodeWithExtData(
    String code, @PathVariable(value = "key") String systemKey, @PathVariable(value = "extdata") String extData,
    HttpServletRequest request, HttpServletResponse response
  ) {
    String schema = getProtocol();
    LOGGER.info("从微信extdata版本接口进入：{}, extData:{}" ,schema, extData);
    if (StringUtils.isEmpty(extData)) {
      // 从code获取token
      Merchant merchant = merchantService.findMerchantByName(systemKey);

      AccessTokenResponse token = wechatService.getToken(code);
      if (token == null) {
        // 让用户登录，不关联微信, 构造不关联微信的url
        redirectNormalUrl(response, merchant, Constants.Channel.WECHAT);
        return;
      }
      WechatUserInfo userInfo = wechatService.getWechatUserInfoFromWechatServer(token.getAccessToken(), token.getOpenId());
      if (userInfo == null || StringUtils.isEmpty(userInfo.getOpenId())) {
        // 让用户登录，不关联微信, 构造不关联微信的url
        redirectNormalUrl(response, merchant, Constants.Channel.WECHAT);
        return;
      }
      WechatUserInfo userInfoInDb = wechatService.findWechatUserInfoFromDb(userInfo.getOpenId());
      // welcome 首次登录
      if (userInfoInDb == null) {
        // 微信用户首次登录界面, 首先保存userInfo, 跳入到微信注册登录界面
        if(StringUtils.isNotBlank(userInfo.getNickName())) {
          String nickName = EmojiUtil.filter(userInfo.getNickName());
          userInfo.setNickName(nickName);
        }
        userInfo = wechatService.saveWechatUserInfo(userInfo);
        redirectWechatLoginUrlWithoutLogin(response, merchant, userInfo, Constants.Channel.WECHAT);
        return;
      }
      if (userInfoInDb.getUserId() == null) {
        // 用户已经微信登录了，但是没有关联信用钱包，跳转到注册页面
        redirectWechatLoginUrlWithoutLogin(response, merchant, userInfoInDb, Constants.Channel.WECHAT);
        return;
      }
      User user = userService.findById(userInfoInDb.getUserId());
      if (user == null) {
        redirectWechatLoginUrlWithoutLogin(response, merchant, userInfoInDb, Constants.Channel.WECHAT);
        return;
      }
      // 已经关联了用户
      // create session, 登进去，该怎么玩怎么玩。
      String redirectUrl = createUserSession(user, merchant, "", schema, Constants.Channel.WECHAT);
      response.setHeader("Location", redirectUrl);
      response.setStatus(301);
    } else {
      HashMap<String, Object> extDataObj;
      try {
        extDataObj =
          JSON.parseObject(extData, new TypeReference<HashMap<String, Object>>() {
          });
      } catch (Exception ex) {
        // 从code获取token
        Merchant merchant = merchantService.findMerchantByName(systemKey);

        AccessTokenResponse token = wechatService.getToken(code);
        if (token == null) {
          // 让用户登录，不关联微信, 构造不关联微信的url
          redirectNormalUrl(response, merchant, Constants.Channel.WECHAT);
          return;
        }
        WechatUserInfo userInfo = wechatService.getWechatUserInfoFromWechatServer(token.getAccessToken(), token.getOpenId());
        if (userInfo == null || StringUtils.isEmpty(userInfo.getOpenId())) {
          // 让用户登录，不关联微信, 构造不关联微信的url
          redirectNormalUrl(response, merchant, Constants.Channel.WECHAT);
          return;
        }
        WechatUserInfo userInfoInDb = wechatService.findWechatUserInfoFromDb(userInfo.getOpenId());
        // welcome 首次登录
        if (userInfoInDb == null) {
          // 微信用户首次登录界面, 首先保存userInfo, 跳入到微信注册登录界面
          if(StringUtils.isNotBlank(userInfo.getNickName())) {
            String nickName = EmojiUtil.filter(userInfo.getNickName());
            userInfo.setNickName(nickName);
          }
          userInfo = wechatService.saveWechatUserInfo(userInfo);
          redirectWechatLoginUrlWithoutLogin(response, merchant, userInfo, Constants.Channel.WECHAT);
          return;
        }
        if (userInfoInDb.getUserId() == null) {
          // 用户已经微信登录了，但是没有关联信用钱包，跳转到注册页面
          redirectWechatLoginUrlWithoutLogin(response, merchant, userInfoInDb, Constants.Channel.WECHAT);
          return;
        }
        User user = userService.findById(userInfoInDb.getUserId());
        if (user == null) {
          redirectWechatLoginUrlWithoutLogin(response, merchant, userInfoInDb, Constants.Channel.WECHAT);
          return;
        }
        // 已经关联了用户
        // create session, 登进去，该怎么玩怎么玩。
        String redirectUrl = createUserSession(user, merchant, "", schema, Constants.Channel.WECHAT);
        response.setHeader("Location", redirectUrl);
        response.setStatus(301);
        return;
      }
      Long registerFrom = (Long) extDataObj.getOrDefault("registerFrom", 1L);
      String redirect = (String) extDataObj.getOrDefault("redirect", "redirect");
      Merchant merchant = merchantService.findMerchantByName(systemKey);
      AccessTokenResponse token = wechatService.getToken(code);
      if (token == null) {
        // 让用户登录，不关联微信, 构造不关联微信的url
        redirectNormalUrl(response, merchant, registerFrom);
        return;
      }
      WechatUserInfo userInfo = wechatService.getWechatUserInfoFromWechatServer(token.getAccessToken(), token.getOpenId());
      if (userInfo == null || StringUtils.isEmpty(userInfo.getOpenId())) {
        // 让用户登录，不关联微信, 构造不关联微信的url
        redirectNormalUrl(response, merchant, registerFrom);
        return;
      }
      WechatUserInfo userInfoInDb = wechatService.findWechatUserInfoFromDb(userInfo.getOpenId());
      // welcome 首次登录
      if (userInfoInDb == null) {
        // 微信用户首次登录界面, 首先保存userInfo, 跳入到微信注册登录界面
        if(StringUtils.isNotBlank(userInfo.getNickName())) {
          String nickName = EmojiUtil.filter(userInfo.getNickName());
          userInfo.setNickName(nickName);
        }
        userInfo = wechatService.saveWechatUserInfo(userInfo);
        redirectWechatLoginUrlWithoutLogin(response, merchant, userInfo, registerFrom);
        return;
      }
      if (userInfoInDb.getUserId() == null) {
        // 用户已经微信登录了，但是没有关联信用钱包，跳转到注册页面
        redirectWechatLoginUrlWithoutLogin(response, merchant, userInfoInDb, registerFrom);
        return;
      }
      User user = userService.findById(userInfoInDb.getUserId());
      if (user == null) {
        redirectWechatLoginUrlWithoutLogin(response, merchant, userInfoInDb, registerFrom);
        return;
      }
      // 已经关联了用户
      // create session, 登进去，该怎么玩怎么玩。
      String redirectUrl = createUserSession(user, merchant, redirect, schema, registerFrom);
      response.setHeader("Location", redirectUrl);
      response.setStatus(301);


    }



  }


  /**
     * 通过redirect_url获取code
     *
     * @param response
     * @return
     */
    @RequestMapping("/receiveCode/{key}")
    public void receiveCodeNoRedirect(String code, @PathVariable(value = "key") String systemKey, HttpServletRequest request, HttpServletResponse response) {
        String schema = request.getScheme();
        LOGGER.info("HTTP协议no redirect:" + schema);
        // 从code获取token
        Merchant merchant = merchantService.findMerchantByName(systemKey);

        AccessTokenResponse token = wechatService.getToken(code);
        if (token == null) {
            // 让用户登录，不关联微信, 构造不关联微信的url
            redirectNormalUrl(response, merchant, Constants.Channel.WECHAT);
            return;
        }
        WechatUserInfo userInfo = wechatService.getWechatUserInfoFromWechatServer(token.getAccessToken(), token.getOpenId());
        if (userInfo == null || StringUtils.isEmpty(userInfo.getOpenId())) {
            // 让用户登录，不关联微信, 构造不关联微信的url
            redirectNormalUrl(response, merchant, Constants.Channel.WECHAT);
            return;
        }
        WechatUserInfo userInfoInDb = wechatService.findWechatUserInfoFromDb(userInfo.getOpenId());
        // welcome 首次登录
        if (userInfoInDb == null) {
            // 微信用户首次登录界面, 首先保存userInfo, 跳入到微信注册登录界面
            if(StringUtils.isNotBlank(userInfo.getNickName())) {
                String nickName = EmojiUtil.filter(userInfo.getNickName());
                userInfo.setNickName(nickName);
            }
            userInfo = wechatService.saveWechatUserInfo(userInfo);
            redirectWechatLoginUrlWithoutLogin(response, merchant, userInfo, Constants.Channel.WECHAT);
            return;
        }
        if (userInfoInDb.getUserId() == null) {
            // 用户已经微信登录了，但是没有关联信用钱包，跳转到注册页面
            redirectWechatLoginUrlWithoutLogin(response, merchant, userInfoInDb, Constants.Channel.WECHAT);
            return;
        }
        User user = userService.findById(userInfoInDb.getUserId());
        if (user == null) {
            redirectWechatLoginUrlWithoutLogin(response, merchant, userInfoInDb, Constants.Channel.WECHAT);
            return;
        }
        // 已经关联了用户
        // create session, 登进去，该怎么玩怎么玩。
        String redirectUrl = createUserSession(user, merchant, "", schema, Constants.Channel.WECHAT);
        response.setHeader("Location", redirectUrl);
        response.setStatus(301);
    }

    private String createUserSession(User user, Merchant merchant, String redirect, String schema, Long registerFrom) {
        //TODO 临时紧急上线修改的.下次上线的时候修复一下,不能这样写.
        String url = "http://passport.xyqb.com";
        if("https".equals(schema)) {
            url = "https://passport.xyqb.com";
        }
        if(StringUtils.isEmpty(redirect) || "redirect".equals(redirect)) {
            LOGGER.info("微信登录:redirect为null,走正常流程.");
            if ("baitiao".equals(merchant.getName())) {
                return loginInWechatWithSessionCreated(user, merchant, "cashTarget5", Constants.Channel.BAITIAO, url, Constants.Channel.WECHAT);
            } else {
                return loginInWechatWithSessionCreated(user, merchant, "cashTarget4", 1L, url, registerFrom);
            }
        } else if("local".equals(redirect)){
            LOGGER.info("微信登录:redirect不为null,创建session跳到指定前端页面.");
            AuthBean authBean = sessionService.createSession(Constants.Channel.WECHAT, Constants.Channel.WECHAT, "", user, merchant);
            LOGGER.info("微信登录:跳转地址{}", url + "/weixin/callback?phoneNo=" + user.getPhoneNo() + "&token=" + authBean.getToken());
            return url + "/weixin/callback?phoneNo=" + user.getPhoneNo() + "&token=" + authBean.getToken();
        }
        return null;
    }

    private String loginInWechatWithSessionCreated(User user, Merchant merchant, String target, Long channelId, String url, Long registerFrom) {
        AuthBean authBean = sessionService.createSession(channelId, registerFrom, "", user, merchant);
        return url + "/landing?token=" + authBean.getToken() + "&registerFrom=" + registerFrom+ "&channelId=" + channelId +"&key=" + merchant.getName() +"&target=" + target;
    }

    private void redirectWechatLoginUrlWithoutLogin(HttpServletResponse response, Merchant merchant, WechatUserInfo userInfo, Long registerFrom) {
        String redirectUrl = assembleWechatRedirectUrl(merchant, userInfo, registerFrom);
        response.setHeader("Location", redirectUrl);
        response.setStatus(301);
    }

    private void redirectNormalUrl(HttpServletResponse response, Merchant merchant, Long registerFrom) {
        String redirectUrl = assembleNormalRedirectUrl(merchant, registerFrom);
        response.setHeader("Location", redirectUrl);
        response.setStatus(301);
    }

    private String assembleNormalRedirectUrl(Merchant merchant, Long registerFrom) {
        if ("baitiao".equals(merchant.getName())) {
            return userUIAddr + "/landing?key=baitiao&target=cashTarget5&channelId=222&registerFrom=198";
        } else {
            return userUIAddr + "/landing?key=xyqb&target=cashTarget4&channelId=1&registerFrom=" + registerFrom;
        }
    }

    private String assembleWechatRedirectUrl(Merchant merchant, WechatUserInfo userInfo, Long registerFrom) {
        if ("baitiao".equals(merchant.getName())) {
            return userUIAddr + "/landing?key=baitiao&target=cashTarget5&registerFrom=198&channelId=222&isWechat=true&openId=" + userInfo.getOpenId();
        } else {
            return userUIAddr + "/landing?key=xyqb&target=cashTarget4&registerFrom= "  + registerFrom + "&channelId=1&isWechat=true&openId=" + userInfo.getOpenId();
        }
    }


}
