package cn.quantgroup.xyqb.filter;

import cn.hutool.extra.spring.SpringUtil;
import cn.quantgroup.xyqb.model.LoginUserContext;
import cn.quantgroup.xyqb.model.OauthResult;
import cn.quantgroup.xyqb.remote.StmsRemoteService;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

@Slf4j
public class TokenInterceptor implements HandlerInterceptor {

  private final LoginUserContext loginUserContext;
  private final StmsRemoteService stmsRemoteService;

  private final List<String> includes = new ArrayList<>();

  public TokenInterceptor() {
    this.loginUserContext = SpringUtil.getBean(LoginUserContext.class);
    this.stmsRemoteService = SpringUtil.getBean(StmsRemoteService.class);
    includes.add("/innerapi/user/disable");
    includes.add("/innerapi/user/active");
  }


  @Override
  public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler)
      throws Exception {
    if (includes.contains(request.getRequestURI())) {
      String accessToken = request.getHeader("Access-Token");
      //原有的拦截器判断逻辑
      if (StringUtils.isNotEmpty(accessToken)) {
        OauthResult oauthResult = stmsRemoteService.checkToken(accessToken);
        if (oauthResult == null || !Objects.equals(2000,
            oauthResult.getCode())) {
          return false;
        }else{
          LinkedHashMap onlineUser = (LinkedHashMap) oauthResult.getData();
          loginUserContext.setUserId(onlineUser.get("id").toString());
          loginUserContext.setUserName(String.valueOf(onlineUser.get("account")));
        }
      }
    }
    return true;
  }

  @Override
  public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler,
      ModelAndView modelAndView) throws Exception {

  }

  @Override
  public void afterCompletion(HttpServletRequest request, HttpServletResponse response,
      Object handler, Exception ex) throws Exception {

  }
}