package cn.quantgroup.xyqb.event;

import cn.quantgroup.xyqb.entity.UserTag;
import cn.quantgroup.xyqb.repository.IUserTagRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;

/**
 * user_tag表，用来监听
 */
@Component
public class UserTagLoginEventListener implements ApplicationListener<UserLoginEvent> {

    @Autowired
    private IUserTagRepository userTagRepository;

    /**
     * 逻辑 每次登录发送UserLoginEvent，落user_tag表
     * 如果没有就新增，如果有就更新
     *
     * @param userLoginEvent UserLoginEvent
     */
    @Override
    public void onApplicationEvent(UserLoginEvent userLoginEvent) {
        if (userLoginEvent.getUserTag() != null) {
            UserTag userTag = userLoginEvent.getUserTag();
            UserTag preTag = userTagRepository.findByUserIdAndTenantIdAndRegisteredFrom(userTag.getUserId(), userTag.getTenantId(), userTag.getRegisteredFrom());

            if (preTag == null) {
                preTag = userTag;
            }

            //创建时间，如果有了，不再更新
            if (userTag.getCreatedAt() == null) {
                preTag.setCreatedAt(LocalDateTime.now());
            }

            preTag.setUpdatedAt(userTag.getUpdatedAt() == null ? LocalDateTime.now() : userTag.getUpdatedAt());

            userTagRepository.save(preTag);
        }
    }
}
