package cn.quantgroup.xyqb.risk.uereventcollecting;

import cn.qg.ec.kinesis.KinesisProducerClient;
import cn.qg.ec.model.base.EventInfo;
import com.amazonaws.services.kinesis.producer.UserRecordResult;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import lombok.extern.slf4j.Slf4j;

import javax.annotation.Nullable;
import java.io.UnsupportedEncodingException;

/**
 * @author ：dongjianhua
 * @date ：Created in 2020/12/21 16:01
 * @description：用户事件采集工具类
 * @modified By：
 * @version: http://confluence.quantgroup.cn/pages/viewpage.action?pageId=34820403
 */
@Slf4j
public class UserEventCollectingUtil {

    private static final FutureCallback<UserRecordResult> CALL_BACK = new MyCallBack();

    public static void addEvent(EventInfo eventInfo) {
        KinesisProducerClient client = KinesisProducerClientFactory.getClient();
        try {
            ListenableFuture<UserRecordResult> future = client.SendRecord(eventInfo);
            Futures.addCallback(future, CALL_BACK);
        } catch (UnsupportedEncodingException e) {
            log.error("发送事件异常UnsupportedEncodingException:{}", e);
        } catch (Exception e) {
            log.error("发送事件未知异常e", e);
        }
    }

    @Slf4j
    public static class MyCallBack implements FutureCallback<UserRecordResult> {

        @Override
        public void onSuccess(@Nullable UserRecordResult userRecordResult) {
            log.info("发送事件成功 SequenceNumber:{}", userRecordResult.getSequenceNumber());
        }

        @Override
        public void onFailure(Throwable throwable) {
            log.error("发送事件失败", throwable);
        }
    }

}
