package cn.quantgroup.xyqb.entity;


import cn.quantgroup.xyqb.entity.baseEntity.OptimisticEntity;
import cn.quantgroup.xyqb.util.StringUtils;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.util.Objects;

/**
 * Created with IntelliJ IDEA.
 *
 * @author: Li JianHua
 * @Date: 2021/9/23
 * @Time: 11:02
 * Description: No Description
 */
@Entity
@Table(name = "oauth_client_details")
public class OauthClientDetailsEntity extends OptimisticEntity implements Serializable {
    private static final long serialVersionUID = 3521505570429896355L;

    private final static String CLASS_NAME = OauthClientDetailsEntity.class.getSimpleName();

    @Id
    @Column(name = "CLIENT_ID", nullable = false)
    private Integer clientId;

    @Column(name = "INSTITUTION_ID", nullable = false, length = 4)
    private String institutionId;

    @Column(name = "PRODUCT_ID", nullable = false, length = 4)
    private String productId;

    @Column(name = "ENCRYPTION_TYPE", nullable = false, length = 4)
    private String encryptionType;

    @Column(name = "ENABLE", nullable = false, length = 4)
    private String enable;

    @Column(name = "RESOURCE_IDS", nullable = true, length = 255)
    private String resourceIds;

    @Column(name = "CLIENT_SECRET", nullable = false, length = 255)
    private String clientSecret;

    @Column(name = "SCOPE", nullable = true, length = 255)
    private String scope;

    @Column(name = "AUTHORIZED_GRANT_TYPES", nullable = true, length = 255)
    private String authorizedGrantTypes;

    @Column(name = "WEB_SERVER_REDIRECT_URI", nullable = true, length = 255)
    private String webServerRedirectUri;

    @Column(name = "AUTHORITIES", nullable = true, length = 255)
    private String authorities;

    @Column(name = "ACCESS_TOKEN_VALIDITY", nullable = true)
    private Integer accessTokenValidity;

    @Column(name = "REFRESH_TOKEN_VALIDITY", nullable = true)
    private Integer refreshTokenValidity;

    @Column(name = "ADDITIONAL_INFORMATION", nullable = true, length = 4096)
    private String additionalInformation;

    @Column(name = "AUTOAPPROVE", nullable = true, length = 255)
    private String autoapprove;

    @Column(name = "SMS_REGISTER_TEMPLATE", nullable = true, length = 255)
    private String smsRegisterTemplate;


    public Integer getClientId() {
        return clientId;
    }

    public void setClientId(Integer clientId) {
        this.clientId = clientId;
    }

    public String getInstitutionId() {
        return institutionId;
    }

    public void setInstitutionId(String institutionId) {
        this.institutionId = institutionId;
    }

    public String getProductId() {
        return productId;
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }

    public String getEncryptionType() {
        return encryptionType;
    }

    public void setEncryptionType(String encryptionType) {
        this.encryptionType = encryptionType;
    }

    public String getEnable() {
        return enable;
    }

    public void setEnable(String enable) {
        this.enable = enable;
    }

    public String getResourceIds() {
        return resourceIds;
    }

    public void setResourceIds(String resourceIds) {
        this.resourceIds = resourceIds;
    }

    public String getClientSecret() {
        return clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String getScope() {
        return scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getAuthorizedGrantTypes() {
        return authorizedGrantTypes;
    }

    public void setAuthorizedGrantTypes(String authorizedGrantTypes) {
        this.authorizedGrantTypes = authorizedGrantTypes;
    }

    public String getWebServerRedirectUri() {
        return webServerRedirectUri;
    }

    public void setWebServerRedirectUri(String webServerRedirectUri) {
        this.webServerRedirectUri = webServerRedirectUri;
    }

    public String getAuthorities() {
        return authorities;
    }

    public void setAuthorities(String authorities) {
        this.authorities = authorities;
    }

    public Integer getAccessTokenValidity() {
        return accessTokenValidity;
    }

    public void setAccessTokenValidity(Integer accessTokenValidity) {
        this.accessTokenValidity = accessTokenValidity;
    }

    public Integer getRefreshTokenValidity() {
        return refreshTokenValidity;
    }

    public void setRefreshTokenValidity(Integer refreshTokenValidity) {
        this.refreshTokenValidity = refreshTokenValidity;
    }

    public String getAdditionalInformation() {
        return additionalInformation;
    }

    public void setAdditionalInformation(String additionalInformation) {
        this.additionalInformation = additionalInformation;
    }

    public String getAutoapprove() {
        return autoapprove;
    }

    public void setAutoapprove(String autoapprove) {
        this.autoapprove = autoapprove;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        OauthClientDetailsEntity that = (OauthClientDetailsEntity) o;
        return Objects.equals(clientId, that.clientId) && Objects.equals(institutionId, that.institutionId) && Objects.equals(productId, that.productId) && Objects.equals(encryptionType, that.encryptionType) && Objects.equals(enable, that.enable) && Objects.equals(resourceIds, that.resourceIds) && Objects.equals(clientSecret, that.clientSecret) && Objects.equals(scope, that.scope) && Objects.equals(authorizedGrantTypes, that.authorizedGrantTypes) && Objects.equals(webServerRedirectUri, that.webServerRedirectUri) && Objects.equals(authorities, that.authorities) && Objects.equals(accessTokenValidity, that.accessTokenValidity) && Objects.equals(refreshTokenValidity, that.refreshTokenValidity) && Objects.equals(additionalInformation, that.additionalInformation) && Objects.equals(autoapprove, that.autoapprove);
    }

    @Override
    public int hashCode() {
        return Objects.hash(clientId, institutionId, productId, encryptionType, enable, resourceIds, clientSecret, scope, authorizedGrantTypes, webServerRedirectUri, authorities, accessTokenValidity, refreshTokenValidity, additionalInformation, autoapprove);
    }

    @Override
    public String getPersistentKey() {
        return StringUtils.toDelimitedString(CLASS_NAME, clientId);
    }

    public String getSmsRegisterTemplate() {
        return smsRegisterTemplate;
    }

    public void setSmsRegisterTemplate(String smsRegisterTemplate) {
        this.smsRegisterTemplate = smsRegisterTemplate;
    }
}
