package cn.quantgroup.xyqb.service.user.impl;

import cn.quantgroup.xyqb.constant.enums.OccupationEnum;
import cn.quantgroup.xyqb.entity.UserExtInfo;
import cn.quantgroup.xyqb.repository.IUserExtInfoRepository;
import cn.quantgroup.xyqb.service.user.IUserExtInfoService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.sql.Timestamp;
import java.util.List;

/**
 * Created by Miraculous on 2017/1/3.
 */
@Slf4j
@Service
public class UserExtInfoServiceImpl implements IUserExtInfoService {

    @Autowired
    private IUserExtInfoRepository userExtInfoRepository;

    @Override
//    @Cacheable(value = "userextinfocache", key = "'extinfo' + #userId", unless = "#result == null", cacheManager = "cacheManager")
    public UserExtInfo findByUserId(Long userId) {
        return userExtInfoRepository.findByUserId(userId);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    @CacheEvict(value = "userextinfocache", key = "'extinfo' + #info.userId", cacheManager = "cacheManager")
    public UserExtInfo save(UserExtInfo info) {
        return userExtInfoRepository.save(info);
    }

    @Override
    public List<UserExtInfo> findByCreatedAtAfterAndCreatedAtBeforeAndOccupationEnum(Timestamp start, Timestamp end) {
        return userExtInfoRepository.findByCreatedAtAfterAndCreatedAtBeforeAndOccupationEnum(start, end, OccupationEnum.STUDENT);
    }
}
