package cn.quantgroup.xyqb.service.user;

import java.util.List;

import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.data.domain.Page;

import cn.quantgroup.xyqb.entity.UserDetail;
import cn.quantgroup.xyqb.service.user.vo.UserDetailVO;

/**
 * Created by 11 on 2016/12/29.
 */
public interface IUserDetailService {
    UserDetail findByUserId(Long userId);

    UserDetail saveUserDetail(UserDetail userDetail) throws DataIntegrityViolationException;

    UserDetail findByPhoneNo(String phoneNo);

    void updateUserQQ(Long userId, String qq);

    void updateUserEmail(Long userId, String email);

    List<UserDetailVO> searchUserDetailList(String name, String phoneNo, String idNo);

    List<UserDetail> findByUserIdIn(List<Long> userIds);

    List<UserDetail> findByPhoneNos(List<String> phoneNos);

    List<UserDetail> findByIdnos(List<String> idnos);

    Page<UserDetail> getUserDetailsPage(List<Long> userId, List<String> phoneNos, List<String> idNos, int pageNumber, int pageSize,

                                        String sortType);

    /**
     * 更新用户的身份证号
     *
     * @param name    name
     * @param idNo    idNo
     * @param phoneNo phoneNo
     * @return 受影响的行数
     */
    int updateIdCard(String name, String idNo, String phoneNo);

    List<UserDetail> findByPhones(List<String> phoneNos);

    /**
     * 按照身份证号和手机号 - 模糊查询
     * @param phoneNo - 手机号
     * @param idNo - 身份证号
     * @return List<UserDetail>
     */
    List<UserDetail> fuzzyQueryByPhoneNoAndIdNo(String phoneNo, String idNo);
}
